using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmSplitUnit
	/// </summary>
	public class FrmSplitUnit : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables
		
		/// <summary>
		/// Our BloodUnitModfication control class
		/// </summary>
		private BOL.BloodUnitModification _bumControl;

		/// <summary>
		/// Current tab the user is clicked on
		/// </summary>
		private BOL.ModifiedUnit _currentTargetUnit;
		
		/// <summary>
		/// Usesd to bypass certain logic when we're setting up the form
		/// </summary>
		private bool _isLoading = false;

		/// <summary>
		/// Needed for CreateTargetTabs
		/// </summary>
		private bool _removingTabs = false;

		private bool _manualCBSetting = true;

		#endregion

		#region FormControls

		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlModify;
		private System.Windows.Forms.TabControl tabTargets;
		private System.Windows.Forms.GroupBox grpPicture;
		private System.Windows.Forms.PictureBox picSplit;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpModificationDetails;
		private System.Windows.Forms.TextBox txtModificationDate;
		private System.Windows.Forms.TextBox txtMethod;
		private System.Windows.Forms.Label lblMethod;
		private System.Windows.Forms.Label lblModificationDate;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updSplitNumber;
		private System.Windows.Forms.RadioButton rdoSplitNumber;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updSplitVolume;
		private System.Windows.Forms.RadioButton rdoSplitVolume;
		private System.Windows.Forms.Label lblSplitmL;
		private System.Windows.Forms.Panel pnlTargetUnit;
		private System.Windows.Forms.TabPage pageTarget1;
		private System.Windows.Forms.TabControl tabOriginal;
		private System.Windows.Forms.TabPage pageOriginalUnit;
		private System.Windows.Forms.Panel pnlOriginalExtraInfo;
		private System.Windows.Forms.TabControl tabOriginalExtraInfo;
		private System.Windows.Forms.TabPage pageOriginalRestricted;
		private System.Windows.Forms.PictureBox picOriginalBiohazard;
		private System.Windows.Forms.TextBox txtOriginalRestrictedStatus;
		private System.Windows.Forms.Label lblOriginalRestrictedStatus;
		private System.Windows.Forms.TextBox txtOriginalRestrictedSSN;
		private System.Windows.Forms.TextBox txtOriginalRestrictedName;
		private System.Windows.Forms.Label lblOriginalRestrictedSSN;
		private System.Windows.Forms.Label lblOriginalRestrictedName;
		private System.Windows.Forms.TabPage pageOriginalAssigned;
		private System.Windows.Forms.TabPage pageOriginalSpecialTesting;
		private System.Windows.Forms.Label lblOriginalSickleCellNeg;
		private System.Windows.Forms.Label lblOriginalCMVNeg;
		private System.Windows.Forms.ListView lvOriginalAntigens;
		private System.Windows.Forms.Label lblOriginalRBCAntigens;
		private System.Windows.Forms.CheckBox cbOriginalSickleCellNeg;
		private System.Windows.Forms.CheckBox cbOriginalCMVNeg;
		private System.Windows.Forms.TextBox txtOriginalDonationType;
		private System.Windows.Forms.Label lblOriginalDonationType;
		private System.Windows.Forms.Panel pnlOriginalUnit;
		private System.Windows.Forms.TextBox txtOriginalUnitStatus;
		private System.Windows.Forms.Label lblOriginalUnitStatus;
		private System.Windows.Forms.TextBox txtOriginalProductName;
		private System.Windows.Forms.TextBox txtOriginalABORh;
		private System.Windows.Forms.TextBox txtOriginalUnitID;
		private System.Windows.Forms.Label lblOriginalProductName;
		private System.Windows.Forms.TextBox txtOriginalExpirationDate;
		private System.Windows.Forms.Label lblOriginalExpirationDate;
		private System.Windows.Forms.Label lblOriginalABORh;
		private System.Windows.Forms.Label lblOriginalUnitID;
		private System.Windows.Forms.ColumnHeader colOriginalAntigen;
		private System.Windows.Forms.ColumnHeader colOriginalPosNeg;
		private System.Windows.Forms.ColumnHeader colTargetAntigens;
		private System.Windows.Forms.ColumnHeader colTargetPosNeg;
		private System.Windows.Forms.TabControl tabSuppliesEquipment;
		private System.Windows.Forms.TabPage pageContainer;
		private System.Windows.Forms.Button btnAddContainer;
		private System.Windows.Forms.ListView lvContainer;
		private System.Windows.Forms.TabPage pageSupplies;
		private System.Windows.Forms.Button btnAddSupplies;
		private System.Windows.Forms.ListView lvSupplies;
		private System.Windows.Forms.TabPage pageEquipment;
		private System.Windows.Forms.Button btnAddEquipment;
		private System.Windows.Forms.ListView lvEquipment;
		private System.Windows.Forms.TabPage pageSCDWafer;
		private System.Windows.Forms.Button btnAddWafer;
		private System.Windows.Forms.ListView lvSCDWafer;
		private System.Windows.Forms.Panel pnlTargetTop;
		private System.Windows.Forms.Panel pnlTargetExtraInfo;
		private System.Windows.Forms.TabControl tabTargetExtraInfo;
		private System.Windows.Forms.TabPage pageTargetRestricted;
		private System.Windows.Forms.PictureBox picTargetBiohazard;
		private System.Windows.Forms.TextBox txtTargetRestrictedStatus;
		private System.Windows.Forms.Label lblTargetTestingStatus;
		private System.Windows.Forms.TextBox txtTargetRestrictedSSN;
		private System.Windows.Forms.TextBox txtTargetRestrictedName;
		private System.Windows.Forms.Label lblTargetRestrictedSSN;
		private System.Windows.Forms.Label lblTargetRestrictedName;
		private System.Windows.Forms.TabPage pageTargetAssigned;
		private System.Windows.Forms.TabPage pageTargetSpecialTesting;
		private System.Windows.Forms.Label lblTargetSickleCellNeg;
		private System.Windows.Forms.Label lblTargetCMVNeg;
		private System.Windows.Forms.ListView lvTargetAntigens;
		private System.Windows.Forms.Label lblTargetRBCAntigens;
		private System.Windows.Forms.CheckBox cbTargetSickleCellNeg;
		private System.Windows.Forms.CheckBox cbTargetCMVNeg;
		private System.Windows.Forms.TextBox txtTargetDonationType;
		private System.Windows.Forms.Label lblTargetDonationType;
		private System.Windows.Forms.Panel pnlTargetUnitInfo;
		private System.Windows.Forms.TextBox txtTargetUnitStatus;
		private System.Windows.Forms.Label lblTargetUnitStatus;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updTargetVolume;
		private System.Windows.Forms.TextBox txtTargetABORh;
		private System.Windows.Forms.TextBox txtTargetUnitId;
		private System.Windows.Forms.DateTimePicker dtpTargetExpirationDate;
		private System.Windows.Forms.Label lblTargetVolume;
		private System.Windows.Forms.Label lblTargetProductName;
		private System.Windows.Forms.Label lblTargetExpirationDate;
		private System.Windows.Forms.Label lblTargetABORh;
		private System.Windows.Forms.Label lblTargetUnitId;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader colSupplyCheckbox;
		private System.Windows.Forms.ColumnHeader colSupplyLotNumber;
		private System.Windows.Forms.ColumnHeader colSupplyName;
		private System.Windows.Forms.ColumnHeader colSupplyManufacturer;
		private System.Windows.Forms.ColumnHeader colSupplyExpires;
		private System.Windows.Forms.ColumnHeader colEquipmentCheckbox;
		private System.Windows.Forms.ColumnHeader colSerialNumber;
		private System.Windows.Forms.ColumnHeader colEquipmentName;
		private System.Windows.Forms.ColumnHeader colEquipmentManufacturer;
		private System.Windows.Forms.ColumnHeader colLocalID;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.Panel pnltarget;
		private System.Windows.Forms.RadioButton rdoIncomplete;
		private System.Windows.Forms.RadioButton rdoComplete;
		private System.Windows.Forms.CheckBox cbOriginalContainer;
		private System.Windows.Forms.TextBox txtTargetProductName;
		private System.Windows.Forms.Label lblOriginalVolume;
		private gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown updOriginalVolume;
		private System.Windows.Forms.Panel pnlTop;
		private System.Windows.Forms.GroupBox grpWeld;
		private System.Windows.Forms.GroupBox grpSplit;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ListView lvOriginalAssigned;
		private System.Windows.Forms.ListView lvTargetAssigned;
		private System.Windows.Forms.Button btnSplitUnit;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors


		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="modifyControl"></param>
		public FrmSplitUnit(BOL.BloodUnitModification modifyControl)
		{			
			this.LockController.LockFunction = Common.LockFunctions.UC025SplitUnits;

			this._isLoading = true;

			InitializeComponent();

			//CR1736 - Lock the BloodUnitStatus record to avoid conflicts with UC_11, etc.
			this.LockController.RecordGuids.Add(modifyControl.SplittingUnit.BloodUnitStatus.BloodUnitStatusGuid);

			//Lock the OrderedUnits (if any)
			foreach(BOL.Patient tmpPatient in modifyControl.SplittingUnit.AssignedToPatients)
			{
				BOL.OrderedUnit tmpOU = new BOL.OrderedUnit(modifyControl.SplittingUnit.BloodUnitGuid, tmpPatient.PatientGuid);
                this.LockController.RecordGuids.Add(tmpOU.OrderedUnitGuid);
			}

			if (!this.SetLocks())
			{
				this.DialogResult = DialogResult.Abort;
				return;
			}

			this._bumControl = modifyControl;

			this.SetComponentProperties();				
			this.CreateTargetTabs();

			this._currentTargetUnit = (BOL.ModifiedUnit)this._bumControl.SplitUnits[this.tabTargets.SelectedIndex];

			this.PopulateSourceDetails();
			this.PopulateTargetDetails();

			this._isLoading = false;

			//Set the broken rules for our control and units
			this._bumControl.SetInitialBrokenRules(this.Name, string.Empty);

			//Attach our events
//25.09 DELETED
//			this._bumControl.ParentVolumeRefresh += new EventHandler(this.RefreshParentVolume);
			this._bumControl.Invalid += new EventHandler(this.ObjectValidityChange);
			this._bumControl.Valid += new EventHandler(this.ObjectValidityChange);
			this._bumControl.ModifiedUnitStateChange += new EventHandler(this.ObjectValidityChange);
			this._bumControl.WeldIndicatorChanged += new EventHandler(this.RefreshExpirationDate);

			//The WeldCompletenessIndicator has TabIndex = 0, which will automatically select
			//on form load.  This will prevent that, and force user selection.
			if (this._bumControl.ModificationMethod == Common.ModifyUnitMethod.SterileConnectingDevice)
			{
				this.btnCancel.TabIndex = 0;
			}

			//This fires off just to make sure the OK button is enabled properly with the right text
			this.ObjectValidityChange(this,System.EventArgs.Empty);

			this.rdoSplitNumber.Focus();

		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmSplitUnit));
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.pnlModify = new System.Windows.Forms.Panel();
			this.pnlTop = new System.Windows.Forms.Panel();
			this.grpModificationDetails = new System.Windows.Forms.GroupBox();
			this.txtModificationDate = new System.Windows.Forms.TextBox();
			this.txtMethod = new System.Windows.Forms.TextBox();
			this.lblMethod = new System.Windows.Forms.Label();
			this.lblModificationDate = new System.Windows.Forms.Label();
			this.grpSplit = new System.Windows.Forms.GroupBox();
			this.btnSplitUnit = new System.Windows.Forms.Button();
			this.lblSplitmL = new System.Windows.Forms.Label();
			this.rdoSplitNumber = new System.Windows.Forms.RadioButton();
			this.updSplitVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.rdoSplitVolume = new System.Windows.Forms.RadioButton();
			this.updSplitNumber = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.grpWeld = new System.Windows.Forms.GroupBox();
			this.rdoComplete = new System.Windows.Forms.RadioButton();
			this.rdoIncomplete = new System.Windows.Forms.RadioButton();
			this.tabOriginal = new System.Windows.Forms.TabControl();
			this.pageOriginalUnit = new System.Windows.Forms.TabPage();
			this.pnlOriginalExtraInfo = new System.Windows.Forms.Panel();
			this.tabOriginalExtraInfo = new System.Windows.Forms.TabControl();
			this.pageOriginalRestricted = new System.Windows.Forms.TabPage();
			this.picOriginalBiohazard = new System.Windows.Forms.PictureBox();
			this.txtOriginalRestrictedStatus = new System.Windows.Forms.TextBox();
			this.lblOriginalRestrictedStatus = new System.Windows.Forms.Label();
			this.txtOriginalRestrictedSSN = new System.Windows.Forms.TextBox();
			this.txtOriginalRestrictedName = new System.Windows.Forms.TextBox();
			this.lblOriginalRestrictedSSN = new System.Windows.Forms.Label();
			this.lblOriginalRestrictedName = new System.Windows.Forms.Label();
			this.pageOriginalAssigned = new System.Windows.Forms.TabPage();
			this.lvOriginalAssigned = new System.Windows.Forms.ListView();
			this.columnHeader13 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader14 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader15 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader16 = new System.Windows.Forms.ColumnHeader();
			this.pageOriginalSpecialTesting = new System.Windows.Forms.TabPage();
			this.lblOriginalSickleCellNeg = new System.Windows.Forms.Label();
			this.lblOriginalCMVNeg = new System.Windows.Forms.Label();
			this.lvOriginalAntigens = new System.Windows.Forms.ListView();
			this.colOriginalAntigen = new System.Windows.Forms.ColumnHeader();
			this.colOriginalPosNeg = new System.Windows.Forms.ColumnHeader();
			this.lblOriginalRBCAntigens = new System.Windows.Forms.Label();
			this.cbOriginalSickleCellNeg = new System.Windows.Forms.CheckBox();
			this.cbOriginalCMVNeg = new System.Windows.Forms.CheckBox();
			this.txtOriginalDonationType = new System.Windows.Forms.TextBox();
			this.lblOriginalDonationType = new System.Windows.Forms.Label();
			this.pnlOriginalUnit = new System.Windows.Forms.Panel();
			this.updOriginalVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.lblOriginalVolume = new System.Windows.Forms.Label();
			this.txtOriginalUnitStatus = new System.Windows.Forms.TextBox();
			this.lblOriginalUnitStatus = new System.Windows.Forms.Label();
			this.txtOriginalProductName = new System.Windows.Forms.TextBox();
			this.txtOriginalABORh = new System.Windows.Forms.TextBox();
			this.txtOriginalUnitID = new System.Windows.Forms.TextBox();
			this.lblOriginalProductName = new System.Windows.Forms.Label();
			this.txtOriginalExpirationDate = new System.Windows.Forms.TextBox();
			this.lblOriginalExpirationDate = new System.Windows.Forms.Label();
			this.lblOriginalABORh = new System.Windows.Forms.Label();
			this.lblOriginalUnitID = new System.Windows.Forms.Label();
			this.tabTargets = new System.Windows.Forms.TabControl();
			this.pageTarget1 = new System.Windows.Forms.TabPage();
			this.grpPicture = new System.Windows.Forms.GroupBox();
			this.picSplit = new System.Windows.Forms.PictureBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.btnAddContainer = new System.Windows.Forms.Button();
			this.lvContainer = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.btnAddSupplies = new System.Windows.Forms.Button();
			this.lvSupplies = new System.Windows.Forms.ListView();
			this.colSupplyCheckbox = new System.Windows.Forms.ColumnHeader();
			this.colSupplyLotNumber = new System.Windows.Forms.ColumnHeader();
			this.colSupplyName = new System.Windows.Forms.ColumnHeader();
			this.colSupplyManufacturer = new System.Windows.Forms.ColumnHeader();
			this.colSupplyExpires = new System.Windows.Forms.ColumnHeader();
			this.btnAddEquipment = new System.Windows.Forms.Button();
			this.lvEquipment = new System.Windows.Forms.ListView();
			this.colEquipmentCheckbox = new System.Windows.Forms.ColumnHeader();
			this.colSerialNumber = new System.Windows.Forms.ColumnHeader();
			this.colEquipmentName = new System.Windows.Forms.ColumnHeader();
			this.colEquipmentManufacturer = new System.Windows.Forms.ColumnHeader();
			this.colLocalID = new System.Windows.Forms.ColumnHeader();
			this.btnAddWafer = new System.Windows.Forms.Button();
			this.lvSCDWafer = new System.Windows.Forms.ListView();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.txtTargetRestrictedStatus = new System.Windows.Forms.TextBox();
			this.txtTargetRestrictedSSN = new System.Windows.Forms.TextBox();
			this.txtTargetRestrictedName = new System.Windows.Forms.TextBox();
			this.lblTargetSickleCellNeg = new System.Windows.Forms.Label();
			this.lblTargetCMVNeg = new System.Windows.Forms.Label();
			this.lvTargetAntigens = new System.Windows.Forms.ListView();
			this.colTargetAntigens = new System.Windows.Forms.ColumnHeader();
			this.colTargetPosNeg = new System.Windows.Forms.ColumnHeader();
			this.cbTargetSickleCellNeg = new System.Windows.Forms.CheckBox();
			this.cbTargetCMVNeg = new System.Windows.Forms.CheckBox();
			this.txtTargetDonationType = new System.Windows.Forms.TextBox();
			this.txtTargetUnitStatus = new System.Windows.Forms.TextBox();
			this.updTargetVolume = new gov.va.med.vbecs.GUI.controls.VbecsNumericUpDown();
			this.txtTargetABORh = new System.Windows.Forms.TextBox();
			this.txtTargetUnitId = new System.Windows.Forms.TextBox();
			this.dtpTargetExpirationDate = new System.Windows.Forms.DateTimePicker();
			this.pnlTargetUnit = new System.Windows.Forms.Panel();
			this.pnltarget = new System.Windows.Forms.Panel();
			this.tabSuppliesEquipment = new System.Windows.Forms.TabControl();
			this.pageContainer = new System.Windows.Forms.TabPage();
			this.cbOriginalContainer = new System.Windows.Forms.CheckBox();
			this.pageSupplies = new System.Windows.Forms.TabPage();
			this.pageEquipment = new System.Windows.Forms.TabPage();
			this.pageSCDWafer = new System.Windows.Forms.TabPage();
			this.pnlTargetTop = new System.Windows.Forms.Panel();
			this.pnlTargetExtraInfo = new System.Windows.Forms.Panel();
			this.tabTargetExtraInfo = new System.Windows.Forms.TabControl();
			this.pageTargetRestricted = new System.Windows.Forms.TabPage();
			this.picTargetBiohazard = new System.Windows.Forms.PictureBox();
			this.lblTargetTestingStatus = new System.Windows.Forms.Label();
			this.lblTargetRestrictedSSN = new System.Windows.Forms.Label();
			this.lblTargetRestrictedName = new System.Windows.Forms.Label();
			this.pageTargetAssigned = new System.Windows.Forms.TabPage();
			this.lvTargetAssigned = new System.Windows.Forms.ListView();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader11 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader12 = new System.Windows.Forms.ColumnHeader();
			this.pageTargetSpecialTesting = new System.Windows.Forms.TabPage();
			this.lblTargetRBCAntigens = new System.Windows.Forms.Label();
			this.lblTargetDonationType = new System.Windows.Forms.Label();
			this.pnlTargetUnitInfo = new System.Windows.Forms.Panel();
			this.txtTargetProductName = new System.Windows.Forms.TextBox();
			this.lblTargetUnitStatus = new System.Windows.Forms.Label();
			this.lblTargetVolume = new System.Windows.Forms.Label();
			this.lblTargetProductName = new System.Windows.Forms.Label();
			this.lblTargetExpirationDate = new System.Windows.Forms.Label();
			this.lblTargetABORh = new System.Windows.Forms.Label();
			this.lblTargetUnitId = new System.Windows.Forms.Label();
			this.pnlModify.SuspendLayout();
			this.pnlTop.SuspendLayout();
			this.grpModificationDetails.SuspendLayout();
			this.grpSplit.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updSplitVolume)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.updSplitNumber)).BeginInit();
			this.grpWeld.SuspendLayout();
			this.tabOriginal.SuspendLayout();
			this.pageOriginalUnit.SuspendLayout();
			this.pnlOriginalExtraInfo.SuspendLayout();
			this.tabOriginalExtraInfo.SuspendLayout();
			this.pageOriginalRestricted.SuspendLayout();
			this.pageOriginalAssigned.SuspendLayout();
			this.pageOriginalSpecialTesting.SuspendLayout();
			this.pnlOriginalUnit.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updOriginalVolume)).BeginInit();
			this.tabTargets.SuspendLayout();
			this.grpPicture.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.updTargetVolume)).BeginInit();
			this.pnlTargetUnit.SuspendLayout();
			this.pnltarget.SuspendLayout();
			this.tabSuppliesEquipment.SuspendLayout();
			this.pageContainer.SuspendLayout();
			this.pageSupplies.SuspendLayout();
			this.pageEquipment.SuspendLayout();
			this.pageSCDWafer.SuspendLayout();
			this.pnlTargetTop.SuspendLayout();
			this.pnlTargetExtraInfo.SuspendLayout();
			this.tabTargetExtraInfo.SuspendLayout();
			this.pageTargetRestricted.SuspendLayout();
			this.pageTargetAssigned.SuspendLayout();
			this.pageTargetSpecialTesting.SuspendLayout();
			this.pnlTargetUnitInfo.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(624, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 507);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(464, 500);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 50;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(544, 500);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 51;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// pnlModify
			// 
			this.pnlModify.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlModify.Controls.Add(this.pnlTop);
			this.pnlModify.Controls.Add(this.tabOriginal);
			this.pnlModify.Controls.Add(this.tabTargets);
			this.pnlModify.Controls.Add(this.grpPicture);
			this.pnlModify.Location = new System.Drawing.Point(0, 32);
			this.pnlModify.Name = "pnlModify";
			this.pnlModify.Size = new System.Drawing.Size(620, 464);
			this.pnlModify.TabIndex = 0;
			// 
			// pnlTop
			// 
			this.pnlTop.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlTop.Controls.Add(this.grpModificationDetails);
			this.pnlTop.Controls.Add(this.grpSplit);
			this.pnlTop.Controls.Add(this.grpWeld);
			this.pnlTop.Location = new System.Drawing.Point(4, 0);
			this.pnlTop.Name = "pnlTop";
			this.pnlTop.Size = new System.Drawing.Size(616, 60);
			this.pnlTop.TabIndex = 0;
			this.pnlTop.TabStop = true;
			// 
			// grpModificationDetails
			// 
			this.grpModificationDetails.AccessibleDescription = "Modification";
			this.grpModificationDetails.AccessibleName = "Modification";
			this.grpModificationDetails.Controls.Add(this.txtModificationDate);
			this.grpModificationDetails.Controls.Add(this.txtMethod);
			this.grpModificationDetails.Controls.Add(this.lblMethod);
			this.grpModificationDetails.Controls.Add(this.lblModificationDate);
			this.grpModificationDetails.Dock = System.Windows.Forms.DockStyle.Fill;
			this.grpModificationDetails.Location = new System.Drawing.Point(208, 0);
			this.grpModificationDetails.Name = "grpModificationDetails";
			this.grpModificationDetails.Size = new System.Drawing.Size(280, 60);
			this.grpModificationDetails.TabIndex = 4;
			this.grpModificationDetails.TabStop = false;
			this.grpModificationDetails.Text = "Modification";
			// 
			// txtModificationDate
			// 
			this.txtModificationDate.AccessibleDescription = "Modification Date";
			this.txtModificationDate.AccessibleName = "Modification Date";
			this.txtModificationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtModificationDate.Location = new System.Drawing.Point(100, 36);
			this.txtModificationDate.Name = "txtModificationDate";
			this.txtModificationDate.ReadOnly = true;
			this.txtModificationDate.Size = new System.Drawing.Size(172, 20);
			this.txtModificationDate.TabIndex = 5;
			this.txtModificationDate.Text = "";
			// 
			// txtMethod
			// 
			this.txtMethod.AccessibleDescription = "Method";
			this.txtMethod.AccessibleName = "Method";
			this.txtMethod.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtMethod.Location = new System.Drawing.Point(100, 12);
			this.txtMethod.Name = "txtMethod";
			this.txtMethod.ReadOnly = true;
			this.txtMethod.Size = new System.Drawing.Size(172, 20);
			this.txtMethod.TabIndex = 4;
			this.txtMethod.Text = "";
			// 
			// lblMethod
			// 
			this.lblMethod.Location = new System.Drawing.Point(8, 16);
			this.lblMethod.Name = "lblMethod";
			this.lblMethod.Size = new System.Drawing.Size(92, 16);
			this.lblMethod.TabIndex = 60;
			this.lblMethod.Text = "Method";
			this.lblMethod.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblModificationDate
			// 
			this.lblModificationDate.Location = new System.Drawing.Point(8, 36);
			this.lblModificationDate.Name = "lblModificationDate";
			this.lblModificationDate.Size = new System.Drawing.Size(92, 20);
			this.lblModificationDate.TabIndex = 58;
			this.lblModificationDate.Text = "Modification Date";
			this.lblModificationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpSplit
			// 
			this.grpSplit.AccessibleDescription = "Split";
			this.grpSplit.AccessibleName = "Split";
			this.grpSplit.Controls.Add(this.btnSplitUnit);
			this.grpSplit.Controls.Add(this.lblSplitmL);
			this.grpSplit.Controls.Add(this.rdoSplitNumber);
			this.grpSplit.Controls.Add(this.updSplitVolume);
			this.grpSplit.Controls.Add(this.rdoSplitVolume);
			this.grpSplit.Controls.Add(this.updSplitNumber);
			this.grpSplit.Dock = System.Windows.Forms.DockStyle.Left;
			this.grpSplit.Location = new System.Drawing.Point(0, 0);
			this.grpSplit.Name = "grpSplit";
			this.grpSplit.Size = new System.Drawing.Size(208, 60);
			this.grpSplit.TabIndex = 0;
			this.grpSplit.TabStop = false;
			this.grpSplit.Text = "Split*";
			// 
			// btnSplitUnit
			// 
			this.btnSplitUnit.Enabled = false;
			this.btnSplitUnit.Location = new System.Drawing.Point(152, 12);
			this.btnSplitUnit.Name = "btnSplitUnit";
			this.btnSplitUnit.Size = new System.Drawing.Size(48, 22);
			this.btnSplitUnit.TabIndex = 2;
			this.btnSplitUnit.Text = "Spli&t";
			this.btnSplitUnit.Click += new System.EventHandler(this.btnSplitUnit_Click);
			// 
			// lblSplitmL
			// 
			this.lblSplitmL.Location = new System.Drawing.Point(144, 36);
			this.lblSplitmL.Name = "lblSplitmL";
			this.lblSplitmL.Size = new System.Drawing.Size(20, 20);
			this.lblSplitmL.TabIndex = 84;
			this.lblSplitmL.Text = "mL";
			this.lblSplitmL.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// rdoSplitNumber
			// 
			this.rdoSplitNumber.AccessibleDescription = "Adult Split";
			this.rdoSplitNumber.AccessibleName = "Adult Split";
			this.rdoSplitNumber.Checked = true;
			this.rdoSplitNumber.Location = new System.Drawing.Point(8, 16);
			this.rdoSplitNumber.Name = "rdoSplitNumber";
			this.rdoSplitNumber.Size = new System.Drawing.Size(80, 16);
			this.rdoSplitNumber.TabIndex = 0;
			this.rdoSplitNumber.TabStop = true;
			this.rdoSplitNumber.Text = "Ad&ult Split";
			// 
			// updSplitVolume
			// 
			this.updSplitVolume.AccessibleDescription = "Pediatric Split Number";
			this.updSplitVolume.AccessibleName = "Pediatric Split Number";
			this.updSplitVolume.Enabled = false;
			this.updSplitVolume.Location = new System.Drawing.Point(100, 36);
			this.updSplitVolume.Name = "updSplitVolume";
			this.updSplitVolume.Size = new System.Drawing.Size(44, 20);
			this.updSplitVolume.TabIndex = 3;
			this.updSplitVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updSplitVolume.Value = new System.Decimal(new int[] {
																		 0,
																		 0,
																		 0,
																		 0});
			// 
			// rdoSplitVolume
			// 
			this.rdoSplitVolume.AccessibleDescription = "Pediatric Split";
			this.rdoSplitVolume.AccessibleName = "Pediatric Split";
			this.rdoSplitVolume.Enabled = false;
			this.rdoSplitVolume.Location = new System.Drawing.Point(8, 36);
			this.rdoSplitVolume.Name = "rdoSplitVolume";
			this.rdoSplitVolume.Size = new System.Drawing.Size(96, 16);
			this.rdoSplitVolume.TabIndex = 3;
			this.rdoSplitVolume.Text = "&Pediatric Split";
			// 
			// updSplitNumber
			// 
			this.updSplitNumber.AccessibleDescription = "Adult Split Number";
			this.updSplitNumber.AccessibleName = "Adult Split Number";
			this.updSplitNumber.Location = new System.Drawing.Point(100, 12);
			this.updSplitNumber.Maximum = new System.Decimal(new int[] {
																		   999,
																		   0,
																		   0,
																		   0});
			this.updSplitNumber.Minimum = new System.Decimal(new int[] {
																		   2,
																		   0,
																		   0,
																		   0});
			this.updSplitNumber.Name = "updSplitNumber";
			this.updSplitNumber.Size = new System.Drawing.Size(44, 20);
			this.updSplitNumber.TabIndex = 1;
			this.updSplitNumber.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updSplitNumber.Value = new System.Decimal(new int[] {
																		 2,
																		 0,
																		 0,
																		 0});
			this.updSplitNumber.TextChanged += new System.EventHandler(this.SplitNumberEvent);
			this.updSplitNumber.Leave += new System.EventHandler(this.SplitNumberLeaveEvent);
			this.updSplitNumber.ValueChanged += new System.EventHandler(this.SplitNumberEvent);
			// 
			// grpWeld
			// 
			this.grpWeld.AccessibleDescription = "Weld";
			this.grpWeld.AccessibleName = "Weld";
			this.grpWeld.Controls.Add(this.rdoComplete);
			this.grpWeld.Controls.Add(this.rdoIncomplete);
			this.grpWeld.Dock = System.Windows.Forms.DockStyle.Right;
			this.grpWeld.Location = new System.Drawing.Point(488, 0);
			this.grpWeld.Name = "grpWeld";
			this.grpWeld.Size = new System.Drawing.Size(128, 60);
			this.grpWeld.TabIndex = 6;
			this.grpWeld.TabStop = false;
			this.grpWeld.Text = "Weld*";
			// 
			// rdoComplete
			// 
			this.rdoComplete.AccessibleDescription = "Weld Complete";
			this.rdoComplete.AccessibleName = "Weld Complete";
			this.rdoComplete.Location = new System.Drawing.Point(8, 16);
			this.rdoComplete.Name = "rdoComplete";
			this.rdoComplete.Size = new System.Drawing.Size(108, 16);
			this.rdoComplete.TabIndex = 6;
			this.rdoComplete.TabStop = true;
			this.rdoComplete.Text = "Wel&d Complete";
			this.rdoComplete.CheckedChanged += new System.EventHandler(this.rdoComplete_CheckedChanged);
			// 
			// rdoIncomplete
			// 
			this.rdoIncomplete.Location = new System.Drawing.Point(8, 36);
			this.rdoIncomplete.Name = "rdoIncomplete";
			this.rdoIncomplete.Size = new System.Drawing.Size(108, 16);
			this.rdoIncomplete.TabIndex = 7;
			this.rdoIncomplete.Text = "Weld &Incomplete";
			this.rdoIncomplete.CheckedChanged += new System.EventHandler(this.rdoIncomplete_CheckedChanged);
			// 
			// tabOriginal
			// 
			this.tabOriginal.AccessibleDescription = "Original Unit";
			this.tabOriginal.AccessibleName = "Original Unit";
			this.tabOriginal.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabOriginal.Controls.Add(this.pageOriginalUnit);
			this.tabOriginal.Location = new System.Drawing.Point(56, 64);
			this.tabOriginal.Name = "tabOriginal";
			this.tabOriginal.SelectedIndex = 0;
			this.tabOriginal.Size = new System.Drawing.Size(564, 152);
			this.tabOriginal.TabIndex = 8;
			// 
			// pageOriginalUnit
			// 
			this.pageOriginalUnit.Controls.Add(this.pnlOriginalExtraInfo);
			this.pageOriginalUnit.Controls.Add(this.pnlOriginalUnit);
			this.pageOriginalUnit.Location = new System.Drawing.Point(4, 23);
			this.pageOriginalUnit.Name = "pageOriginalUnit";
			this.pageOriginalUnit.Size = new System.Drawing.Size(556, 125);
			this.pageOriginalUnit.TabIndex = 0;
			this.pageOriginalUnit.Text = "Original Unit";
			// 
			// pnlOriginalExtraInfo
			// 
			this.pnlOriginalExtraInfo.Controls.Add(this.tabOriginalExtraInfo);
			this.pnlOriginalExtraInfo.Controls.Add(this.txtOriginalDonationType);
			this.pnlOriginalExtraInfo.Controls.Add(this.lblOriginalDonationType);
			this.pnlOriginalExtraInfo.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlOriginalExtraInfo.Location = new System.Drawing.Point(300, 0);
			this.pnlOriginalExtraInfo.Name = "pnlOriginalExtraInfo";
			this.pnlOriginalExtraInfo.Size = new System.Drawing.Size(256, 125);
			this.pnlOriginalExtraInfo.TabIndex = 15;
			// 
			// tabOriginalExtraInfo
			// 
			this.tabOriginalExtraInfo.Alignment = System.Windows.Forms.TabAlignment.Bottom;
			this.tabOriginalExtraInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalRestricted);
			this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalAssigned);
			this.tabOriginalExtraInfo.Controls.Add(this.pageOriginalSpecialTesting);
			this.tabOriginalExtraInfo.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tabOriginalExtraInfo.Location = new System.Drawing.Point(4, 24);
			this.tabOriginalExtraInfo.Name = "tabOriginalExtraInfo";
			this.tabOriginalExtraInfo.SelectedIndex = 0;
			this.tabOriginalExtraInfo.Size = new System.Drawing.Size(248, 100);
			this.tabOriginalExtraInfo.TabIndex = 16;
			this.tabOriginalExtraInfo.SelectedIndexChanged += new System.EventHandler(this.ExtraInfoTabsClicked);
			// 
			// pageOriginalRestricted
			// 
			this.pageOriginalRestricted.Controls.Add(this.picOriginalBiohazard);
			this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedStatus);
			this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedStatus);
			this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedSSN);
			this.pageOriginalRestricted.Controls.Add(this.txtOriginalRestrictedName);
			this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedSSN);
			this.pageOriginalRestricted.Controls.Add(this.lblOriginalRestrictedName);
			this.pageOriginalRestricted.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageOriginalRestricted.Location = new System.Drawing.Point(4, 4);
			this.pageOriginalRestricted.Name = "pageOriginalRestricted";
			this.pageOriginalRestricted.Size = new System.Drawing.Size(240, 75);
			this.pageOriginalRestricted.TabIndex = 0;
			this.pageOriginalRestricted.Text = "Restricted For";
			// 
			// picOriginalBiohazard
			// 
			this.picOriginalBiohazard.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picOriginalBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picOriginalBiohazard.Image")));
			this.picOriginalBiohazard.Location = new System.Drawing.Point(212, 40);
			this.picOriginalBiohazard.Name = "picOriginalBiohazard";
			this.picOriginalBiohazard.Size = new System.Drawing.Size(26, 28);
			this.picOriginalBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picOriginalBiohazard.TabIndex = 34;
			this.picOriginalBiohazard.TabStop = false;
			this.picOriginalBiohazard.Visible = false;
			// 
			// txtOriginalRestrictedStatus
			// 
			this.txtOriginalRestrictedStatus.AccessibleDescription = "Disease marker testing";
			this.txtOriginalRestrictedStatus.AccessibleName = "Disease marker testing";
			this.txtOriginalRestrictedStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalRestrictedStatus.Location = new System.Drawing.Point(88, 48);
			this.txtOriginalRestrictedStatus.Name = "txtOriginalRestrictedStatus";
			this.txtOriginalRestrictedStatus.ReadOnly = true;
			this.txtOriginalRestrictedStatus.Size = new System.Drawing.Size(120, 20);
			this.txtOriginalRestrictedStatus.TabIndex = 19;
			this.txtOriginalRestrictedStatus.Text = "";
			// 
			// lblOriginalRestrictedStatus
			// 
			this.lblOriginalRestrictedStatus.Location = new System.Drawing.Point(0, 48);
			this.lblOriginalRestrictedStatus.Name = "lblOriginalRestrictedStatus";
			this.lblOriginalRestrictedStatus.Size = new System.Drawing.Size(92, 24);
			this.lblOriginalRestrictedStatus.TabIndex = 15;
			this.lblOriginalRestrictedStatus.Text = "Disease Marker Testing";
			this.lblOriginalRestrictedStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalRestrictedSSN
			// 
			this.txtOriginalRestrictedSSN.AccessibleDescription = "Patient I D ";
			this.txtOriginalRestrictedSSN.AccessibleName = "Patient I D ";
			this.txtOriginalRestrictedSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalRestrictedSSN.Location = new System.Drawing.Point(88, 24);
			this.txtOriginalRestrictedSSN.Name = "txtOriginalRestrictedSSN";
			this.txtOriginalRestrictedSSN.ReadOnly = true;
			this.txtOriginalRestrictedSSN.Size = new System.Drawing.Size(120, 20);
			this.txtOriginalRestrictedSSN.TabIndex = 18;
			this.txtOriginalRestrictedSSN.Text = "";
			// 
			// txtOriginalRestrictedName
			// 
			this.txtOriginalRestrictedName.AccessibleDescription = "Patient Name";
			this.txtOriginalRestrictedName.AccessibleName = "Patient Name";
			this.txtOriginalRestrictedName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalRestrictedName.Location = new System.Drawing.Point(88, 0);
			this.txtOriginalRestrictedName.Name = "txtOriginalRestrictedName";
			this.txtOriginalRestrictedName.ReadOnly = true;
			this.txtOriginalRestrictedName.Size = new System.Drawing.Size(152, 20);
			this.txtOriginalRestrictedName.TabIndex = 17;
			this.txtOriginalRestrictedName.Text = "";
			// 
			// lblOriginalRestrictedSSN
			// 
			this.lblOriginalRestrictedSSN.Location = new System.Drawing.Point(0, 24);
			this.lblOriginalRestrictedSSN.Name = "lblOriginalRestrictedSSN";
			this.lblOriginalRestrictedSSN.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalRestrictedSSN.TabIndex = 12;
			this.lblOriginalRestrictedSSN.Text = "Patient ID";
			this.lblOriginalRestrictedSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalRestrictedName
			// 
			this.lblOriginalRestrictedName.Location = new System.Drawing.Point(0, 0);
			this.lblOriginalRestrictedName.Name = "lblOriginalRestrictedName";
			this.lblOriginalRestrictedName.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalRestrictedName.TabIndex = 11;
			this.lblOriginalRestrictedName.Text = "Patient Name";
			this.lblOriginalRestrictedName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pageOriginalAssigned
			// 
			this.pageOriginalAssigned.Controls.Add(this.lvOriginalAssigned);
			this.pageOriginalAssigned.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageOriginalAssigned.Location = new System.Drawing.Point(4, 4);
			this.pageOriginalAssigned.Name = "pageOriginalAssigned";
			this.pageOriginalAssigned.Size = new System.Drawing.Size(240, 75);
			this.pageOriginalAssigned.TabIndex = 1;
			this.pageOriginalAssigned.Text = "Assigned To";
			this.pageOriginalAssigned.Visible = false;
			// 
			// lvOriginalAssigned
			// 
			this.lvOriginalAssigned.AccessibleDescription = "Assigned To";
			this.lvOriginalAssigned.AccessibleName = "Assigned To";
			this.lvOriginalAssigned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvOriginalAssigned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								 this.columnHeader13,
																								 this.columnHeader14,
																								 this.columnHeader15,
																								 this.columnHeader16});
			this.lvOriginalAssigned.Location = new System.Drawing.Point(0, 0);
			this.lvOriginalAssigned.Name = "lvOriginalAssigned";
			this.lvOriginalAssigned.Size = new System.Drawing.Size(240, 72);
			this.lvOriginalAssigned.TabIndex = 20;
			this.lvOriginalAssigned.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader13
			// 
			this.columnHeader13.Text = "Patient Name";
			this.columnHeader13.Width = 80;
			// 
			// columnHeader14
			// 
			this.columnHeader14.Text = "Patient ID";
			// 
			// columnHeader15
			// 
			this.columnHeader15.Text = "Specimen UID";
			this.columnHeader15.Width = 80;
			// 
			// columnHeader16
			// 
			this.columnHeader16.Text = "Specimen Expires";
			this.columnHeader16.Width = 100;
			// 
			// pageOriginalSpecialTesting
			// 
			this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalSickleCellNeg);
			this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalCMVNeg);
			this.pageOriginalSpecialTesting.Controls.Add(this.lvOriginalAntigens);
			this.pageOriginalSpecialTesting.Controls.Add(this.lblOriginalRBCAntigens);
			this.pageOriginalSpecialTesting.Controls.Add(this.cbOriginalSickleCellNeg);
			this.pageOriginalSpecialTesting.Controls.Add(this.cbOriginalCMVNeg);
			this.pageOriginalSpecialTesting.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageOriginalSpecialTesting.Location = new System.Drawing.Point(4, 4);
			this.pageOriginalSpecialTesting.Name = "pageOriginalSpecialTesting";
			this.pageOriginalSpecialTesting.Size = new System.Drawing.Size(240, 75);
			this.pageOriginalSpecialTesting.TabIndex = 2;
			this.pageOriginalSpecialTesting.Text = "Special Testing";
			this.pageOriginalSpecialTesting.Visible = false;
			// 
			// lblOriginalSickleCellNeg
			// 
			this.lblOriginalSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.lblOriginalSickleCellNeg.Name = "lblOriginalSickleCellNeg";
			this.lblOriginalSickleCellNeg.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalSickleCellNeg.TabIndex = 17;
			this.lblOriginalSickleCellNeg.Text = "Sickle Cell &Neg?";
			this.lblOriginalSickleCellNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalCMVNeg
			// 
			this.lblOriginalCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.lblOriginalCMVNeg.Name = "lblOriginalCMVNeg";
			this.lblOriginalCMVNeg.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalCMVNeg.TabIndex = 16;
			this.lblOriginalCMVNeg.Text = "C&MV Neg?";
			this.lblOriginalCMVNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvOriginalAntigens
			// 
			this.lvOriginalAntigens.AccessibleDescription = "R B C Antigens";
			this.lvOriginalAntigens.AccessibleName = "R B C Antigens";
			this.lvOriginalAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvOriginalAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								 this.colOriginalAntigen,
																								 this.colOriginalPosNeg});
			this.lvOriginalAntigens.FullRowSelect = true;
			this.lvOriginalAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.lvOriginalAntigens.Location = new System.Drawing.Point(124, 16);
			this.lvOriginalAntigens.MultiSelect = false;
			this.lvOriginalAntigens.Name = "lvOriginalAntigens";
			this.lvOriginalAntigens.Size = new System.Drawing.Size(116, 56);
			this.lvOriginalAntigens.TabIndex = 23;
			this.lvOriginalAntigens.View = System.Windows.Forms.View.Details;
			// 
			// colOriginalAntigen
			// 
			this.colOriginalAntigen.Text = "";
			this.colOriginalAntigen.Width = 5;
			// 
			// colOriginalPosNeg
			// 
			this.colOriginalPosNeg.Text = "";
			this.colOriginalPosNeg.Width = 5;
			// 
			// lblOriginalRBCAntigens
			// 
			this.lblOriginalRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblOriginalRBCAntigens.Location = new System.Drawing.Point(124, 0);
			this.lblOriginalRBCAntigens.Name = "lblOriginalRBCAntigens";
			this.lblOriginalRBCAntigens.Size = new System.Drawing.Size(96, 16);
			this.lblOriginalRBCAntigens.TabIndex = 10;
			this.lblOriginalRBCAntigens.Text = "RBC Antigens";
			this.lblOriginalRBCAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbOriginalSickleCellNeg
			// 
			this.cbOriginalSickleCellNeg.AccessibleDescription = "Sickle Cell Negative";
			this.cbOriginalSickleCellNeg.AccessibleName = "Sickle Cell Negative";
			this.cbOriginalSickleCellNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbOriginalSickleCellNeg.Enabled = false;
			this.cbOriginalSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.cbOriginalSickleCellNeg.Name = "cbOriginalSickleCellNeg";
			this.cbOriginalSickleCellNeg.Size = new System.Drawing.Size(112, 20);
			this.cbOriginalSickleCellNeg.TabIndex = 22;
			this.cbOriginalSickleCellNeg.Text = "Sickle Cell &Neg";
			// 
			// cbOriginalCMVNeg
			// 
			this.cbOriginalCMVNeg.AccessibleDescription = "C M V Negative";
			this.cbOriginalCMVNeg.AccessibleName = "C M V Negative";
			this.cbOriginalCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbOriginalCMVNeg.Enabled = false;
			this.cbOriginalCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.cbOriginalCMVNeg.Name = "cbOriginalCMVNeg";
			this.cbOriginalCMVNeg.Size = new System.Drawing.Size(112, 20);
			this.cbOriginalCMVNeg.TabIndex = 21;
			this.cbOriginalCMVNeg.Text = "C&MV Neg";
			// 
			// txtOriginalDonationType
			// 
			this.txtOriginalDonationType.AccessibleDescription = "Donation Type";
			this.txtOriginalDonationType.AccessibleName = "Donation Type";
			this.txtOriginalDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalDonationType.Location = new System.Drawing.Point(96, 4);
			this.txtOriginalDonationType.Name = "txtOriginalDonationType";
			this.txtOriginalDonationType.ReadOnly = true;
			this.txtOriginalDonationType.Size = new System.Drawing.Size(152, 20);
			this.txtOriginalDonationType.TabIndex = 15;
			this.txtOriginalDonationType.Text = "";
			// 
			// lblOriginalDonationType
			// 
			this.lblOriginalDonationType.Location = new System.Drawing.Point(8, 4);
			this.lblOriginalDonationType.Name = "lblOriginalDonationType";
			this.lblOriginalDonationType.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalDonationType.TabIndex = 65;
			this.lblOriginalDonationType.Text = "Donation Type";
			this.lblOriginalDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlOriginalUnit
			// 
			this.pnlOriginalUnit.Controls.Add(this.updOriginalVolume);
			this.pnlOriginalUnit.Controls.Add(this.lblOriginalVolume);
			this.pnlOriginalUnit.Controls.Add(this.txtOriginalUnitStatus);
			this.pnlOriginalUnit.Controls.Add(this.lblOriginalUnitStatus);
			this.pnlOriginalUnit.Controls.Add(this.txtOriginalProductName);
			this.pnlOriginalUnit.Controls.Add(this.txtOriginalABORh);
			this.pnlOriginalUnit.Controls.Add(this.txtOriginalUnitID);
			this.pnlOriginalUnit.Controls.Add(this.lblOriginalProductName);
			this.pnlOriginalUnit.Controls.Add(this.txtOriginalExpirationDate);
			this.pnlOriginalUnit.Controls.Add(this.lblOriginalExpirationDate);
			this.pnlOriginalUnit.Controls.Add(this.lblOriginalABORh);
			this.pnlOriginalUnit.Controls.Add(this.lblOriginalUnitID);
			this.pnlOriginalUnit.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlOriginalUnit.Location = new System.Drawing.Point(0, 0);
			this.pnlOriginalUnit.Name = "pnlOriginalUnit";
			this.pnlOriginalUnit.Size = new System.Drawing.Size(300, 125);
			this.pnlOriginalUnit.TabIndex = 9;
			// 
			// updOriginalVolume
			// 
			this.updOriginalVolume.AccessibleDescription = "Volume Milliliters";
			this.updOriginalVolume.AccessibleName = "Volume Milliliters";
			this.updOriginalVolume.Enabled = false;
			this.updOriginalVolume.Location = new System.Drawing.Point(240, 52);
			this.updOriginalVolume.Maximum = new System.Decimal(new int[] {
																			  9999,
																			  0,
																			  0,
																			  0});
			this.updOriginalVolume.Name = "updOriginalVolume";
			this.updOriginalVolume.Size = new System.Drawing.Size(48, 20);
			this.updOriginalVolume.TabIndex = 12;
			this.updOriginalVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updOriginalVolume.Value = new System.Decimal(new int[] {
																			0,
																			0,
																			0,
																			0});
			// 
			// lblOriginalVolume
			// 
			this.lblOriginalVolume.Location = new System.Drawing.Point(176, 52);
			this.lblOriginalVolume.Name = "lblOriginalVolume";
			this.lblOriginalVolume.Size = new System.Drawing.Size(68, 20);
			this.lblOriginalVolume.TabIndex = 71;
			this.lblOriginalVolume.Text = "Volume (ml)";
			this.lblOriginalVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalUnitStatus
			// 
			this.txtOriginalUnitStatus.AccessibleDescription = "Unit Status";
			this.txtOriginalUnitStatus.AccessibleName = "Unit Status";
			this.txtOriginalUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalUnitStatus.Location = new System.Drawing.Point(88, 100);
			this.txtOriginalUnitStatus.Name = "txtOriginalUnitStatus";
			this.txtOriginalUnitStatus.ReadOnly = true;
			this.txtOriginalUnitStatus.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalUnitStatus.TabIndex = 14;
			this.txtOriginalUnitStatus.Text = "";
			// 
			// lblOriginalUnitStatus
			// 
			this.lblOriginalUnitStatus.Location = new System.Drawing.Point(4, 100);
			this.lblOriginalUnitStatus.Name = "lblOriginalUnitStatus";
			this.lblOriginalUnitStatus.Size = new System.Drawing.Size(88, 20);
			this.lblOriginalUnitStatus.TabIndex = 68;
			this.lblOriginalUnitStatus.Text = "Unit Status";
			this.lblOriginalUnitStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalProductName
			// 
			this.txtOriginalProductName.AccessibleDescription = "Product";
			this.txtOriginalProductName.AccessibleName = "Product";
			this.txtOriginalProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalProductName.Location = new System.Drawing.Point(88, 28);
			this.txtOriginalProductName.Name = "txtOriginalProductName";
			this.txtOriginalProductName.ReadOnly = true;
			this.txtOriginalProductName.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalProductName.TabIndex = 10;
			this.txtOriginalProductName.Text = "";
			// 
			// txtOriginalABORh
			// 
			this.txtOriginalABORh.AccessibleDescription = "A B O R H";
			this.txtOriginalABORh.AccessibleName = "A B O R H";
			this.txtOriginalABORh.Location = new System.Drawing.Point(88, 52);
			this.txtOriginalABORh.Name = "txtOriginalABORh";
			this.txtOriginalABORh.ReadOnly = true;
			this.txtOriginalABORh.Size = new System.Drawing.Size(80, 20);
			this.txtOriginalABORh.TabIndex = 11;
			this.txtOriginalABORh.Text = "";
			// 
			// txtOriginalUnitID
			// 
			this.txtOriginalUnitID.AccessibleDescription = "Unit I D";
			this.txtOriginalUnitID.AccessibleName = "Unit I D";
			this.txtOriginalUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalUnitID.Location = new System.Drawing.Point(88, 4);
			this.txtOriginalUnitID.Name = "txtOriginalUnitID";
			this.txtOriginalUnitID.ReadOnly = true;
			this.txtOriginalUnitID.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalUnitID.TabIndex = 9;
			this.txtOriginalUnitID.Text = "";
			// 
			// lblOriginalProductName
			// 
			this.lblOriginalProductName.Location = new System.Drawing.Point(4, 28);
			this.lblOriginalProductName.Name = "lblOriginalProductName";
			this.lblOriginalProductName.Size = new System.Drawing.Size(96, 20);
			this.lblOriginalProductName.TabIndex = 66;
			this.lblOriginalProductName.Text = "Product";
			this.lblOriginalProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtOriginalExpirationDate
			// 
			this.txtOriginalExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtOriginalExpirationDate.AccessibleName = "Expiration Date";
			this.txtOriginalExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtOriginalExpirationDate.Location = new System.Drawing.Point(88, 76);
			this.txtOriginalExpirationDate.Name = "txtOriginalExpirationDate";
			this.txtOriginalExpirationDate.ReadOnly = true;
			this.txtOriginalExpirationDate.Size = new System.Drawing.Size(200, 20);
			this.txtOriginalExpirationDate.TabIndex = 13;
			this.txtOriginalExpirationDate.Text = "";
			// 
			// lblOriginalExpirationDate
			// 
			this.lblOriginalExpirationDate.Location = new System.Drawing.Point(4, 76);
			this.lblOriginalExpirationDate.Name = "lblOriginalExpirationDate";
			this.lblOriginalExpirationDate.Size = new System.Drawing.Size(88, 20);
			this.lblOriginalExpirationDate.TabIndex = 64;
			this.lblOriginalExpirationDate.Text = "Expiration Date";
			this.lblOriginalExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalABORh
			// 
			this.lblOriginalABORh.Location = new System.Drawing.Point(4, 52);
			this.lblOriginalABORh.Name = "lblOriginalABORh";
			this.lblOriginalABORh.Size = new System.Drawing.Size(80, 20);
			this.lblOriginalABORh.TabIndex = 63;
			this.lblOriginalABORh.Text = "ABO/Rh";
			this.lblOriginalABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblOriginalUnitID
			// 
			this.lblOriginalUnitID.Location = new System.Drawing.Point(4, 4);
			this.lblOriginalUnitID.Name = "lblOriginalUnitID";
			this.lblOriginalUnitID.Size = new System.Drawing.Size(92, 20);
			this.lblOriginalUnitID.TabIndex = 62;
			this.lblOriginalUnitID.Text = "Unit ID";
			this.lblOriginalUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// tabTargets
			// 
			this.tabTargets.AccessibleDescription = "Target Units";
			this.tabTargets.AccessibleName = "Target Units";
			this.tabTargets.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabTargets.Controls.Add(this.pageTarget1);
			this.tabTargets.Location = new System.Drawing.Point(56, 216);
			this.tabTargets.Name = "tabTargets";
			this.tabTargets.SelectedIndex = 0;
			this.tabTargets.Size = new System.Drawing.Size(564, 246);
			this.tabTargets.TabIndex = 24;
			this.tabTargets.SelectedIndexChanged += new System.EventHandler(this.tabTargets_SelectedIndexChanged);
			// 
			// pageTarget1
			// 
			this.pageTarget1.Location = new System.Drawing.Point(4, 23);
			this.pageTarget1.Name = "pageTarget1";
			this.pageTarget1.Size = new System.Drawing.Size(556, 219);
			this.pageTarget1.TabIndex = 0;
			this.pageTarget1.Text = "Target Unit 1";
			// 
			// grpPicture
			// 
			this.grpPicture.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpPicture.Controls.Add(this.picSplit);
			this.grpPicture.Location = new System.Drawing.Point(4, 60);
			this.grpPicture.Name = "grpPicture";
			this.grpPicture.Size = new System.Drawing.Size(52, 402);
			this.grpPicture.TabIndex = 3;
			this.grpPicture.TabStop = false;
			// 
			// picSplit
			// 
			this.picSplit.Image = ((System.Drawing.Image)(resources.GetObject("picSplit.Image")));
			this.picSplit.Location = new System.Drawing.Point(4, 12);
			this.picSplit.Name = "picSplit";
			this.picSplit.Size = new System.Drawing.Size(45, 45);
			this.picSplit.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picSplit.TabIndex = 0;
			this.picSplit.TabStop = false;
			// 
			// btnAddContainer
			// 
			this.btnAddContainer.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddContainer.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddContainer.Location = new System.Drawing.Point(452, 4);
			this.btnAddContainer.Name = "btnAddContainer";
			this.btnAddContainer.Size = new System.Drawing.Size(92, 23);
			this.btnAddContainer.TabIndex = 43;
			this.btnAddContainer.Text = "&Add Container*";
			this.btnAddContainer.Click += new System.EventHandler(this.btnAddContainer_Click);
			// 
			// lvContainer
			// 
			this.lvContainer.AccessibleDescription = "Container";
			this.lvContainer.AccessibleName = "Container";
			this.lvContainer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvContainer.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.columnHeader1,
																						  this.columnHeader2,
																						  this.columnHeader3,
																						  this.columnHeader4});
			this.lvContainer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvContainer.FullRowSelect = true;
			this.lvContainer.Location = new System.Drawing.Point(0, 0);
			this.lvContainer.MultiSelect = false;
			this.lvContainer.Name = "lvContainer";
			this.lvContainer.Size = new System.Drawing.Size(448, 48);
			this.lvContainer.TabIndex = 41;
			this.lvContainer.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Lot Number";
			this.columnHeader1.Width = 70;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Supply Type";
			this.columnHeader2.Width = 150;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Manufacturer";
			this.columnHeader3.Width = 120;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Expires";
			this.columnHeader4.Width = 80;
			// 
			// btnAddSupplies
			// 
			this.btnAddSupplies.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddSupplies.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddSupplies.Location = new System.Drawing.Point(452, 4);
			this.btnAddSupplies.Name = "btnAddSupplies";
			this.btnAddSupplies.Size = new System.Drawing.Size(92, 23);
			this.btnAddSupplies.TabIndex = 45;
			this.btnAddSupplies.Text = "Add &Supplies";
			this.btnAddSupplies.Click += new System.EventHandler(this.btnAddSupplies_Click);
			// 
			// lvSupplies
			// 
			this.lvSupplies.AccessibleDescription = "Supplies";
			this.lvSupplies.AccessibleName = "Supplies";
			this.lvSupplies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSupplies.CheckBoxes = true;
			this.lvSupplies.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.colSupplyCheckbox,
																						 this.colSupplyLotNumber,
																						 this.colSupplyName,
																						 this.colSupplyManufacturer,
																						 this.colSupplyExpires});
			this.lvSupplies.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvSupplies.FullRowSelect = true;
			this.lvSupplies.Location = new System.Drawing.Point(0, 0);
			this.lvSupplies.MultiSelect = false;
			this.lvSupplies.Name = "lvSupplies";
			this.lvSupplies.Size = new System.Drawing.Size(448, 66);
			this.lvSupplies.TabIndex = 44;
			this.lvSupplies.View = System.Windows.Forms.View.Details;
			this.lvSupplies.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSupplies_ColumnClick);
			this.lvSupplies.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvSupplies_ItemCheck);
			// 
			// colSupplyCheckbox
			// 
			this.colSupplyCheckbox.Text = "";
			this.colSupplyCheckbox.Width = 20;
			// 
			// colSupplyLotNumber
			// 
			this.colSupplyLotNumber.Text = "Lot Number";
			this.colSupplyLotNumber.Width = 70;
			// 
			// colSupplyName
			// 
			this.colSupplyName.Text = "Supply Type";
			this.colSupplyName.Width = 150;
			// 
			// colSupplyManufacturer
			// 
			this.colSupplyManufacturer.Text = "Manufacturer";
			this.colSupplyManufacturer.Width = 120;
			// 
			// colSupplyExpires
			// 
			this.colSupplyExpires.Text = "Expires";
			this.colSupplyExpires.Width = 80;
			// 
			// btnAddEquipment
			// 
			this.btnAddEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddEquipment.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddEquipment.Location = new System.Drawing.Point(448, 4);
			this.btnAddEquipment.Name = "btnAddEquipment";
			this.btnAddEquipment.Size = new System.Drawing.Size(96, 23);
			this.btnAddEquipment.TabIndex = 47;
			this.btnAddEquipment.Text = "Add &Equipment";
			this.btnAddEquipment.Click += new System.EventHandler(this.btnAddEquipment_Click);
			// 
			// lvEquipment
			// 
			this.lvEquipment.AccessibleDescription = "Equipment";
			this.lvEquipment.AccessibleName = "Equipment";
			this.lvEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvEquipment.CheckBoxes = true;
			this.lvEquipment.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.colEquipmentCheckbox,
																						  this.colSerialNumber,
																						  this.colEquipmentName,
																						  this.colEquipmentManufacturer,
																						  this.colLocalID});
			this.lvEquipment.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvEquipment.FullRowSelect = true;
			this.lvEquipment.Location = new System.Drawing.Point(0, 0);
			this.lvEquipment.MultiSelect = false;
			this.lvEquipment.Name = "lvEquipment";
			this.lvEquipment.Size = new System.Drawing.Size(448, 66);
			this.lvEquipment.TabIndex = 46;
			this.lvEquipment.View = System.Windows.Forms.View.Details;
			this.lvEquipment.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvEquipment_ColumnClick);
			this.lvEquipment.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvEquipment_ItemCheck);
			// 
			// colEquipmentCheckbox
			// 
			this.colEquipmentCheckbox.Text = "";
			this.colEquipmentCheckbox.Width = 20;
			// 
			// colSerialNumber
			// 
			this.colSerialNumber.Text = "ID Number";
			this.colSerialNumber.Width = 70;
			// 
			// colEquipmentName
			// 
			this.colEquipmentName.Text = "Equipment Name";
			this.colEquipmentName.Width = 150;
			// 
			// colEquipmentManufacturer
			// 
			this.colEquipmentManufacturer.Text = "Manufacturer";
			this.colEquipmentManufacturer.Width = 120;
			// 
			// colLocalID
			// 
			this.colLocalID.Text = "Local ID";
			this.colLocalID.Width = 80;
			// 
			// btnAddWafer
			// 
			this.btnAddWafer.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAddWafer.ImageAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnAddWafer.Location = new System.Drawing.Point(452, 4);
			this.btnAddWafer.Name = "btnAddWafer";
			this.btnAddWafer.Size = new System.Drawing.Size(92, 23);
			this.btnAddWafer.TabIndex = 49;
			this.btnAddWafer.Text = "Add &Wafer";
			this.btnAddWafer.Click += new System.EventHandler(this.btnAddWafer_Click);
			// 
			// lvSCDWafer
			// 
			this.lvSCDWafer.AccessibleDescription = "S C D Wafer";
			this.lvSCDWafer.AccessibleName = "S C D Wafer";
			this.lvSCDWafer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSCDWafer.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader5,
																						 this.columnHeader6,
																						 this.columnHeader7,
																						 this.columnHeader8});
			this.lvSCDWafer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lvSCDWafer.FullRowSelect = true;
			this.lvSCDWafer.Location = new System.Drawing.Point(0, 0);
			this.lvSCDWafer.MultiSelect = false;
			this.lvSCDWafer.Name = "lvSCDWafer";
			this.lvSCDWafer.Size = new System.Drawing.Size(448, 64);
			this.lvSCDWafer.TabIndex = 48;
			this.lvSCDWafer.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Lot Number";
			this.columnHeader5.Width = 70;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Supply Type";
			this.columnHeader6.Width = 150;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Manufacturer";
			this.columnHeader7.Width = 120;
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Expires";
			this.columnHeader8.Width = 80;
			// 
			// txtTargetRestrictedStatus
			// 
			this.txtTargetRestrictedStatus.AccessibleDescription = "Disease Marker Testing";
			this.txtTargetRestrictedStatus.AccessibleName = "Disease Marker Testing";
			this.txtTargetRestrictedStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetRestrictedStatus.Location = new System.Drawing.Point(88, 48);
			this.txtTargetRestrictedStatus.Name = "txtTargetRestrictedStatus";
			this.txtTargetRestrictedStatus.ReadOnly = true;
			this.txtTargetRestrictedStatus.Size = new System.Drawing.Size(120, 20);
			this.txtTargetRestrictedStatus.TabIndex = 35;
			this.txtTargetRestrictedStatus.Text = "";
			// 
			// txtTargetRestrictedSSN
			// 
			this.txtTargetRestrictedSSN.AccessibleDescription = "Patient I D";
			this.txtTargetRestrictedSSN.AccessibleName = "Patient I D";
			this.txtTargetRestrictedSSN.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetRestrictedSSN.Location = new System.Drawing.Point(88, 24);
			this.txtTargetRestrictedSSN.Name = "txtTargetRestrictedSSN";
			this.txtTargetRestrictedSSN.ReadOnly = true;
			this.txtTargetRestrictedSSN.Size = new System.Drawing.Size(120, 20);
			this.txtTargetRestrictedSSN.TabIndex = 34;
			this.txtTargetRestrictedSSN.Text = "";
			// 
			// txtTargetRestrictedName
			// 
			this.txtTargetRestrictedName.AccessibleDescription = "Patient Name";
			this.txtTargetRestrictedName.AccessibleName = "Patient Name";
			this.txtTargetRestrictedName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetRestrictedName.Location = new System.Drawing.Point(88, 0);
			this.txtTargetRestrictedName.Name = "txtTargetRestrictedName";
			this.txtTargetRestrictedName.ReadOnly = true;
			this.txtTargetRestrictedName.Size = new System.Drawing.Size(152, 20);
			this.txtTargetRestrictedName.TabIndex = 33;
			this.txtTargetRestrictedName.Text = "";
			// 
			// lblTargetSickleCellNeg
			// 
			this.lblTargetSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.lblTargetSickleCellNeg.Name = "lblTargetSickleCellNeg";
			this.lblTargetSickleCellNeg.Size = new System.Drawing.Size(92, 20);
			this.lblTargetSickleCellNeg.TabIndex = 19;
			this.lblTargetSickleCellNeg.Text = "Sic&kle Cell Neg?";
			this.lblTargetSickleCellNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetCMVNeg
			// 
			this.lblTargetCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.lblTargetCMVNeg.Name = "lblTargetCMVNeg";
			this.lblTargetCMVNeg.Size = new System.Drawing.Size(92, 20);
			this.lblTargetCMVNeg.TabIndex = 18;
			this.lblTargetCMVNeg.Text = "CM&V Neg?";
			this.lblTargetCMVNeg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lvTargetAntigens
			// 
			this.lvTargetAntigens.AccessibleDescription = "R B C Antigens";
			this.lvTargetAntigens.AccessibleName = "R B C Antigens";
			this.lvTargetAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTargetAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.colTargetAntigens,
																							   this.colTargetPosNeg});
			this.lvTargetAntigens.FullRowSelect = true;
			this.lvTargetAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.lvTargetAntigens.Location = new System.Drawing.Point(124, 16);
			this.lvTargetAntigens.MultiSelect = false;
			this.lvTargetAntigens.Name = "lvTargetAntigens";
			this.lvTargetAntigens.Size = new System.Drawing.Size(116, 56);
			this.lvTargetAntigens.TabIndex = 39;
			this.lvTargetAntigens.View = System.Windows.Forms.View.Details;
			// 
			// colTargetAntigens
			// 
			this.colTargetAntigens.Text = "";
			this.colTargetAntigens.Width = 5;
			// 
			// colTargetPosNeg
			// 
			this.colTargetPosNeg.Text = "";
			this.colTargetPosNeg.Width = 35;
			// 
			// cbTargetSickleCellNeg
			// 
			this.cbTargetSickleCellNeg.AccessibleDescription = "Sickle Cell Negative";
			this.cbTargetSickleCellNeg.AccessibleName = "Sickle Cell Negative";
			this.cbTargetSickleCellNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbTargetSickleCellNeg.Enabled = false;
			this.cbTargetSickleCellNeg.Location = new System.Drawing.Point(0, 40);
			this.cbTargetSickleCellNeg.Name = "cbTargetSickleCellNeg";
			this.cbTargetSickleCellNeg.Size = new System.Drawing.Size(112, 20);
			this.cbTargetSickleCellNeg.TabIndex = 38;
			this.cbTargetSickleCellNeg.Text = "Sic&kle Cell Neg";
			// 
			// cbTargetCMVNeg
			// 
			this.cbTargetCMVNeg.AccessibleDescription = "C M V Negative";
			this.cbTargetCMVNeg.AccessibleName = "C M V Negative";
			this.cbTargetCMVNeg.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbTargetCMVNeg.Enabled = false;
			this.cbTargetCMVNeg.Location = new System.Drawing.Point(0, 16);
			this.cbTargetCMVNeg.Name = "cbTargetCMVNeg";
			this.cbTargetCMVNeg.Size = new System.Drawing.Size(112, 20);
			this.cbTargetCMVNeg.TabIndex = 37;
			this.cbTargetCMVNeg.Text = "CM&V Neg";
			// 
			// txtTargetDonationType
			// 
			this.txtTargetDonationType.AccessibleDescription = "Donation Type";
			this.txtTargetDonationType.AccessibleName = "Donation Type";
			this.txtTargetDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetDonationType.Location = new System.Drawing.Point(96, 4);
			this.txtTargetDonationType.Name = "txtTargetDonationType";
			this.txtTargetDonationType.ReadOnly = true;
			this.txtTargetDonationType.Size = new System.Drawing.Size(152, 20);
			this.txtTargetDonationType.TabIndex = 31;
			this.txtTargetDonationType.Text = "";
			// 
			// txtTargetUnitStatus
			// 
			this.txtTargetUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetUnitStatus.Location = new System.Drawing.Point(88, 100);
			this.txtTargetUnitStatus.Name = "txtTargetUnitStatus";
			this.txtTargetUnitStatus.ReadOnly = true;
			this.txtTargetUnitStatus.Size = new System.Drawing.Size(200, 20);
			this.txtTargetUnitStatus.TabIndex = 30;
			this.txtTargetUnitStatus.Text = "";
			// 
			// updTargetVolume
			// 
			this.updTargetVolume.AccessibleDescription = "Volume Milliliters";
			this.updTargetVolume.AccessibleName = "Volume Milliliters";
			this.updTargetVolume.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.updTargetVolume.Location = new System.Drawing.Point(240, 52);
			this.updTargetVolume.Maximum = new System.Decimal(new int[] {
																			999999,
																			0,
																			0,
																			0});
			this.updTargetVolume.Minimum = new System.Decimal(new int[] {
																			999999,
																			0,
																			0,
																			-2147483648});
			this.updTargetVolume.Name = "updTargetVolume";
			this.updTargetVolume.Size = new System.Drawing.Size(48, 20);
			this.updTargetVolume.TabIndex = 28;
			this.updTargetVolume.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.updTargetVolume.Value = new System.Decimal(new int[] {
																		  1,
																		  0,
																		  0,
																		  0});
			this.updTargetVolume.TextChanged += new System.EventHandler(this.TargetVolumeEvent);
			this.updTargetVolume.Leave += new System.EventHandler(this.updTargetVolume_Leave);
			this.updTargetVolume.ValueChanged += new System.EventHandler(this.TargetVolumeEvent);
			// 
			// txtTargetABORh
			// 
			this.txtTargetABORh.AccessibleDescription = "A B O R H";
			this.txtTargetABORh.AccessibleName = "A B O R H";
			this.txtTargetABORh.Location = new System.Drawing.Point(88, 52);
			this.txtTargetABORh.Name = "txtTargetABORh";
			this.txtTargetABORh.ReadOnly = true;
			this.txtTargetABORh.Size = new System.Drawing.Size(80, 20);
			this.txtTargetABORh.TabIndex = 27;
			this.txtTargetABORh.Text = "";
			// 
			// txtTargetUnitId
			// 
			this.txtTargetUnitId.AccessibleDescription = "Unit I D";
			this.txtTargetUnitId.AccessibleName = "Unit I D";
			this.txtTargetUnitId.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetUnitId.Location = new System.Drawing.Point(88, 4);
			this.txtTargetUnitId.Name = "txtTargetUnitId";
			this.txtTargetUnitId.ReadOnly = true;
			this.txtTargetUnitId.Size = new System.Drawing.Size(200, 20);
			this.txtTargetUnitId.TabIndex = 25;
			this.txtTargetUnitId.Text = "";
			// 
			// dtpTargetExpirationDate
			// 
			this.dtpTargetExpirationDate.AccessibleDescription = "Expiration Date";
			this.dtpTargetExpirationDate.AccessibleName = "Expiration Date";
			this.dtpTargetExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpTargetExpirationDate.CustomFormat = "";
			this.dtpTargetExpirationDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpTargetExpirationDate.Location = new System.Drawing.Point(88, 76);
			this.dtpTargetExpirationDate.Name = "dtpTargetExpirationDate";
			this.dtpTargetExpirationDate.TabIndex = 29;
			this.dtpTargetExpirationDate.Leave += new System.EventHandler(this.dtpTargetExpirationDate_Leave);
			// 
			// pnlTargetUnit
			// 
			this.pnlTargetUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlTargetUnit.Controls.Add(this.pnltarget);
			this.pnlTargetUnit.Location = new System.Drawing.Point(60, 272);
			this.pnlTargetUnit.Name = "pnlTargetUnit";
			this.pnlTargetUnit.Size = new System.Drawing.Size(556, 216);
			this.pnlTargetUnit.TabIndex = 25;
			// 
			// pnltarget
			// 
			this.pnltarget.Controls.Add(this.tabSuppliesEquipment);
			this.pnltarget.Controls.Add(this.pnlTargetTop);
			this.pnltarget.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnltarget.Location = new System.Drawing.Point(0, 0);
			this.pnltarget.Name = "pnltarget";
			this.pnltarget.Size = new System.Drawing.Size(556, 216);
			this.pnltarget.TabIndex = 25;
			// 
			// tabSuppliesEquipment
			// 
			this.tabSuppliesEquipment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabSuppliesEquipment.Controls.Add(this.pageContainer);
			this.tabSuppliesEquipment.Controls.Add(this.pageSupplies);
			this.tabSuppliesEquipment.Controls.Add(this.pageEquipment);
			this.tabSuppliesEquipment.Controls.Add(this.pageSCDWafer);
			this.tabSuppliesEquipment.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tabSuppliesEquipment.Location = new System.Drawing.Point(0, 124);
			this.tabSuppliesEquipment.Multiline = true;
			this.tabSuppliesEquipment.Name = "tabSuppliesEquipment";
			this.tabSuppliesEquipment.SelectedIndex = 0;
			this.tabSuppliesEquipment.Size = new System.Drawing.Size(552, 92);
			this.tabSuppliesEquipment.TabIndex = 40;
			// 
			// pageContainer
			// 
			this.pageContainer.Controls.Add(this.cbOriginalContainer);
			this.pageContainer.Controls.Add(this.btnAddContainer);
			this.pageContainer.Controls.Add(this.lvContainer);
			this.pageContainer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageContainer.Location = new System.Drawing.Point(4, 21);
			this.pageContainer.Name = "pageContainer";
			this.pageContainer.Size = new System.Drawing.Size(544, 67);
			this.pageContainer.TabIndex = 2;
			this.pageContainer.Text = "Container";
			// 
			// cbOriginalContainer
			// 
			this.cbOriginalContainer.AccessibleDescription = "Original Container";
			this.cbOriginalContainer.AccessibleName = "Original Container";
			this.cbOriginalContainer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbOriginalContainer.Location = new System.Drawing.Point(0, 48);
			this.cbOriginalContainer.Name = "cbOriginalContainer";
			this.cbOriginalContainer.Size = new System.Drawing.Size(122, 16);
			this.cbOriginalContainer.TabIndex = 42;
			this.cbOriginalContainer.Text = "O&riginal Container";
			this.cbOriginalContainer.CheckedChanged += new System.EventHandler(this.cbOriginalContainer_CheckedChanged);
			// 
			// pageSupplies
			// 
			this.pageSupplies.Controls.Add(this.btnAddSupplies);
			this.pageSupplies.Controls.Add(this.lvSupplies);
			this.pageSupplies.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageSupplies.Location = new System.Drawing.Point(4, 21);
			this.pageSupplies.Name = "pageSupplies";
			this.pageSupplies.Size = new System.Drawing.Size(544, 67);
			this.pageSupplies.TabIndex = 0;
			this.pageSupplies.Text = "Supplies";
			this.pageSupplies.Visible = false;
			// 
			// pageEquipment
			// 
			this.pageEquipment.Controls.Add(this.btnAddEquipment);
			this.pageEquipment.Controls.Add(this.lvEquipment);
			this.pageEquipment.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageEquipment.Location = new System.Drawing.Point(4, 21);
			this.pageEquipment.Name = "pageEquipment";
			this.pageEquipment.Size = new System.Drawing.Size(544, 67);
			this.pageEquipment.TabIndex = 1;
			this.pageEquipment.Text = "Equipment";
			this.pageEquipment.Visible = false;
			// 
			// pageSCDWafer
			// 
			this.pageSCDWafer.Controls.Add(this.btnAddWafer);
			this.pageSCDWafer.Controls.Add(this.lvSCDWafer);
			this.pageSCDWafer.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageSCDWafer.Location = new System.Drawing.Point(4, 21);
			this.pageSCDWafer.Name = "pageSCDWafer";
			this.pageSCDWafer.Size = new System.Drawing.Size(544, 67);
			this.pageSCDWafer.TabIndex = 3;
			this.pageSCDWafer.Text = "SCD Wafer";
			this.pageSCDWafer.Visible = false;
			// 
			// pnlTargetTop
			// 
			this.pnlTargetTop.Controls.Add(this.pnlTargetExtraInfo);
			this.pnlTargetTop.Controls.Add(this.pnlTargetUnitInfo);
			this.pnlTargetTop.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlTargetTop.Location = new System.Drawing.Point(0, 0);
			this.pnlTargetTop.Name = "pnlTargetTop";
			this.pnlTargetTop.Size = new System.Drawing.Size(556, 124);
			this.pnlTargetTop.TabIndex = 25;
			// 
			// pnlTargetExtraInfo
			// 
			this.pnlTargetExtraInfo.Controls.Add(this.tabTargetExtraInfo);
			this.pnlTargetExtraInfo.Controls.Add(this.txtTargetDonationType);
			this.pnlTargetExtraInfo.Controls.Add(this.lblTargetDonationType);
			this.pnlTargetExtraInfo.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlTargetExtraInfo.Location = new System.Drawing.Point(300, 0);
			this.pnlTargetExtraInfo.Name = "pnlTargetExtraInfo";
			this.pnlTargetExtraInfo.Size = new System.Drawing.Size(256, 124);
			this.pnlTargetExtraInfo.TabIndex = 31;
			// 
			// tabTargetExtraInfo
			// 
			this.tabTargetExtraInfo.Alignment = System.Windows.Forms.TabAlignment.Bottom;
			this.tabTargetExtraInfo.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabTargetExtraInfo.Controls.Add(this.pageTargetRestricted);
			this.tabTargetExtraInfo.Controls.Add(this.pageTargetAssigned);
			this.tabTargetExtraInfo.Controls.Add(this.pageTargetSpecialTesting);
			this.tabTargetExtraInfo.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tabTargetExtraInfo.Location = new System.Drawing.Point(4, 24);
			this.tabTargetExtraInfo.Multiline = true;
			this.tabTargetExtraInfo.Name = "tabTargetExtraInfo";
			this.tabTargetExtraInfo.SelectedIndex = 0;
			this.tabTargetExtraInfo.Size = new System.Drawing.Size(248, 100);
			this.tabTargetExtraInfo.TabIndex = 32;
			this.tabTargetExtraInfo.SelectedIndexChanged += new System.EventHandler(this.ExtraInfoTabsClicked);
			// 
			// pageTargetRestricted
			// 
			this.pageTargetRestricted.Controls.Add(this.picTargetBiohazard);
			this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedStatus);
			this.pageTargetRestricted.Controls.Add(this.lblTargetTestingStatus);
			this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedSSN);
			this.pageTargetRestricted.Controls.Add(this.txtTargetRestrictedName);
			this.pageTargetRestricted.Controls.Add(this.lblTargetRestrictedSSN);
			this.pageTargetRestricted.Controls.Add(this.lblTargetRestrictedName);
			this.pageTargetRestricted.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageTargetRestricted.Location = new System.Drawing.Point(4, 4);
			this.pageTargetRestricted.Name = "pageTargetRestricted";
			this.pageTargetRestricted.Size = new System.Drawing.Size(240, 75);
			this.pageTargetRestricted.TabIndex = 0;
			this.pageTargetRestricted.Text = "Restricted For";
			// 
			// picTargetBiohazard
			// 
			this.picTargetBiohazard.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picTargetBiohazard.Image = ((System.Drawing.Image)(resources.GetObject("picTargetBiohazard.Image")));
			this.picTargetBiohazard.Location = new System.Drawing.Point(212, 40);
			this.picTargetBiohazard.Name = "picTargetBiohazard";
			this.picTargetBiohazard.Size = new System.Drawing.Size(26, 28);
			this.picTargetBiohazard.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.picTargetBiohazard.TabIndex = 35;
			this.picTargetBiohazard.TabStop = false;
			this.picTargetBiohazard.Visible = false;
			// 
			// lblTargetTestingStatus
			// 
			this.lblTargetTestingStatus.Location = new System.Drawing.Point(0, 48);
			this.lblTargetTestingStatus.Name = "lblTargetTestingStatus";
			this.lblTargetTestingStatus.Size = new System.Drawing.Size(92, 24);
			this.lblTargetTestingStatus.TabIndex = 15;
			this.lblTargetTestingStatus.Text = "Disease Marker Testing";
			this.lblTargetTestingStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetRestrictedSSN
			// 
			this.lblTargetRestrictedSSN.Location = new System.Drawing.Point(0, 24);
			this.lblTargetRestrictedSSN.Name = "lblTargetRestrictedSSN";
			this.lblTargetRestrictedSSN.Size = new System.Drawing.Size(92, 20);
			this.lblTargetRestrictedSSN.TabIndex = 12;
			this.lblTargetRestrictedSSN.Text = "Patient ID";
			this.lblTargetRestrictedSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetRestrictedName
			// 
			this.lblTargetRestrictedName.Location = new System.Drawing.Point(0, 0);
			this.lblTargetRestrictedName.Name = "lblTargetRestrictedName";
			this.lblTargetRestrictedName.Size = new System.Drawing.Size(92, 20);
			this.lblTargetRestrictedName.TabIndex = 11;
			this.lblTargetRestrictedName.Text = "Patient Name";
			this.lblTargetRestrictedName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pageTargetAssigned
			// 
			this.pageTargetAssigned.Controls.Add(this.lvTargetAssigned);
			this.pageTargetAssigned.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageTargetAssigned.Location = new System.Drawing.Point(4, 4);
			this.pageTargetAssigned.Name = "pageTargetAssigned";
			this.pageTargetAssigned.Size = new System.Drawing.Size(240, 75);
			this.pageTargetAssigned.TabIndex = 1;
			this.pageTargetAssigned.Text = "Assigned To";
			this.pageTargetAssigned.Visible = false;
			// 
			// lvTargetAssigned
			// 
			this.lvTargetAssigned.AccessibleDescription = "Assigned To";
			this.lvTargetAssigned.AccessibleName = "Assigned To";
			this.lvTargetAssigned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvTargetAssigned.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							   this.columnHeader9,
																							   this.columnHeader10,
																							   this.columnHeader11,
																							   this.columnHeader12});
			this.lvTargetAssigned.Location = new System.Drawing.Point(0, 0);
			this.lvTargetAssigned.Name = "lvTargetAssigned";
			this.lvTargetAssigned.Size = new System.Drawing.Size(240, 72);
			this.lvTargetAssigned.TabIndex = 36;
			this.lvTargetAssigned.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Patient Name";
			this.columnHeader9.Width = 80;
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "Patient ID";
			// 
			// columnHeader11
			// 
			this.columnHeader11.Text = "Specimen UID";
			this.columnHeader11.Width = 80;
			// 
			// columnHeader12
			// 
			this.columnHeader12.Text = "Specimen Expires";
			this.columnHeader12.Width = 100;
			// 
			// pageTargetSpecialTesting
			// 
			this.pageTargetSpecialTesting.Controls.Add(this.lblTargetSickleCellNeg);
			this.pageTargetSpecialTesting.Controls.Add(this.lblTargetCMVNeg);
			this.pageTargetSpecialTesting.Controls.Add(this.lvTargetAntigens);
			this.pageTargetSpecialTesting.Controls.Add(this.lblTargetRBCAntigens);
			this.pageTargetSpecialTesting.Controls.Add(this.cbTargetSickleCellNeg);
			this.pageTargetSpecialTesting.Controls.Add(this.cbTargetCMVNeg);
			this.pageTargetSpecialTesting.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageTargetSpecialTesting.Location = new System.Drawing.Point(4, 4);
			this.pageTargetSpecialTesting.Name = "pageTargetSpecialTesting";
			this.pageTargetSpecialTesting.Size = new System.Drawing.Size(240, 75);
			this.pageTargetSpecialTesting.TabIndex = 2;
			this.pageTargetSpecialTesting.Text = "Special Testing";
			this.pageTargetSpecialTesting.Visible = false;
			// 
			// lblTargetRBCAntigens
			// 
			this.lblTargetRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblTargetRBCAntigens.Location = new System.Drawing.Point(124, 0);
			this.lblTargetRBCAntigens.Name = "lblTargetRBCAntigens";
			this.lblTargetRBCAntigens.Size = new System.Drawing.Size(92, 16);
			this.lblTargetRBCAntigens.TabIndex = 2;
			this.lblTargetRBCAntigens.Text = "RBC Antigens";
			this.lblTargetRBCAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetDonationType
			// 
			this.lblTargetDonationType.Location = new System.Drawing.Point(8, 4);
			this.lblTargetDonationType.Name = "lblTargetDonationType";
			this.lblTargetDonationType.Size = new System.Drawing.Size(92, 20);
			this.lblTargetDonationType.TabIndex = 127;
			this.lblTargetDonationType.Text = "Donation Type";
			this.lblTargetDonationType.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlTargetUnitInfo
			// 
			this.pnlTargetUnitInfo.Controls.Add(this.txtTargetProductName);
			this.pnlTargetUnitInfo.Controls.Add(this.txtTargetUnitStatus);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetUnitStatus);
			this.pnlTargetUnitInfo.Controls.Add(this.updTargetVolume);
			this.pnlTargetUnitInfo.Controls.Add(this.txtTargetABORh);
			this.pnlTargetUnitInfo.Controls.Add(this.txtTargetUnitId);
			this.pnlTargetUnitInfo.Controls.Add(this.dtpTargetExpirationDate);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetVolume);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetProductName);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetExpirationDate);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetABORh);
			this.pnlTargetUnitInfo.Controls.Add(this.lblTargetUnitId);
			this.pnlTargetUnitInfo.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlTargetUnitInfo.Location = new System.Drawing.Point(0, 0);
			this.pnlTargetUnitInfo.Name = "pnlTargetUnitInfo";
			this.pnlTargetUnitInfo.Size = new System.Drawing.Size(300, 124);
			this.pnlTargetUnitInfo.TabIndex = 25;
			// 
			// txtTargetProductName
			// 
			this.txtTargetProductName.AccessibleDescription = "Product";
			this.txtTargetProductName.AccessibleName = "Product";
			this.txtTargetProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTargetProductName.Location = new System.Drawing.Point(88, 28);
			this.txtTargetProductName.Name = "txtTargetProductName";
			this.txtTargetProductName.ReadOnly = true;
			this.txtTargetProductName.Size = new System.Drawing.Size(200, 20);
			this.txtTargetProductName.TabIndex = 26;
			this.txtTargetProductName.Text = "";
			// 
			// lblTargetUnitStatus
			// 
			this.lblTargetUnitStatus.Location = new System.Drawing.Point(4, 100);
			this.lblTargetUnitStatus.Name = "lblTargetUnitStatus";
			this.lblTargetUnitStatus.Size = new System.Drawing.Size(88, 20);
			this.lblTargetUnitStatus.TabIndex = 131;
			this.lblTargetUnitStatus.Text = "Unit Status";
			this.lblTargetUnitStatus.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetVolume
			// 
			this.lblTargetVolume.Location = new System.Drawing.Point(172, 52);
			this.lblTargetVolume.Name = "lblTargetVolume";
			this.lblTargetVolume.Size = new System.Drawing.Size(76, 20);
			this.lblTargetVolume.TabIndex = 129;
			this.lblTargetVolume.Text = "Volume (ml)*";
			this.lblTargetVolume.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetProductName
			// 
			this.lblTargetProductName.Location = new System.Drawing.Point(4, 28);
			this.lblTargetProductName.Name = "lblTargetProductName";
			this.lblTargetProductName.Size = new System.Drawing.Size(96, 20);
			this.lblTargetProductName.TabIndex = 128;
			this.lblTargetProductName.Text = "Product";
			this.lblTargetProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetExpirationDate
			// 
			this.lblTargetExpirationDate.Location = new System.Drawing.Point(4, 76);
			this.lblTargetExpirationDate.Name = "lblTargetExpirationDate";
			this.lblTargetExpirationDate.Size = new System.Drawing.Size(92, 20);
			this.lblTargetExpirationDate.TabIndex = 126;
			this.lblTargetExpirationDate.Text = "Expiration Date*";
			this.lblTargetExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetABORh
			// 
			this.lblTargetABORh.Location = new System.Drawing.Point(4, 52);
			this.lblTargetABORh.Name = "lblTargetABORh";
			this.lblTargetABORh.Size = new System.Drawing.Size(92, 20);
			this.lblTargetABORh.TabIndex = 125;
			this.lblTargetABORh.Text = "ABO/Rh";
			this.lblTargetABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblTargetUnitId
			// 
			this.lblTargetUnitId.Location = new System.Drawing.Point(4, 4);
			this.lblTargetUnitId.Name = "lblTargetUnitId";
			this.lblTargetUnitId.Size = new System.Drawing.Size(92, 20);
			this.lblTargetUnitId.TabIndex = 124;
			this.lblTargetUnitId.Text = "Unit ID";
			this.lblTargetUnitId.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// FrmSplitUnit
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(624, 523);
			this.Controls.Add(this.pnlTargetUnit);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.pnlModify);
			this.hlphelpChm.SetHelpKeyword(this, "Split_a_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(632, 550);
			this.Name = "FrmSplitUnit";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Split/Divide Unit";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmSplitUnit_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlModify, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.pnlTargetUnit, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.pnlModify.ResumeLayout(false);
			this.pnlTop.ResumeLayout(false);
			this.grpModificationDetails.ResumeLayout(false);
			this.grpSplit.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updSplitVolume)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.updSplitNumber)).EndInit();
			this.grpWeld.ResumeLayout(false);
			this.tabOriginal.ResumeLayout(false);
			this.pageOriginalUnit.ResumeLayout(false);
			this.pnlOriginalExtraInfo.ResumeLayout(false);
			this.tabOriginalExtraInfo.ResumeLayout(false);
			this.pageOriginalRestricted.ResumeLayout(false);
			this.pageOriginalAssigned.ResumeLayout(false);
			this.pageOriginalSpecialTesting.ResumeLayout(false);
			this.pnlOriginalUnit.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updOriginalVolume)).EndInit();
			this.tabTargets.ResumeLayout(false);
			this.grpPicture.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.updTargetVolume)).EndInit();
			this.pnlTargetUnit.ResumeLayout(false);
			this.pnltarget.ResumeLayout(false);
			this.tabSuppliesEquipment.ResumeLayout(false);
			this.pageContainer.ResumeLayout(false);
			this.pageSupplies.ResumeLayout(false);
			this.pageEquipment.ResumeLayout(false);
			this.pageSCDWafer.ResumeLayout(false);
			this.pnlTargetTop.ResumeLayout(false);
			this.pnlTargetExtraInfo.ResumeLayout(false);
			this.tabTargetExtraInfo.ResumeLayout(false);
			this.pageTargetRestricted.ResumeLayout(false);
			this.pageTargetAssigned.ResumeLayout(false);
			this.pageTargetSpecialTesting.ResumeLayout(false);
			this.pnlTargetUnitInfo.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods

		/// <summary>
		/// Dispose
		/// </summary>
		/// <param name="disposing"></param>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Sets the enabled properties of the Container listview/Buttons
		/// </summary>
		/// <param name="enable"></param>
		private void EnableContainer(bool enable)
		{
			if (enable)
				this.btnAddContainer.Text = "Add Container*";
			else
				this.btnAddContainer.Text = "Add Container";

			this.lvContainer.Enabled = enable;
			this.btnAddContainer.Enabled = enable;
		}


		/// <summary>
		/// Sets the enabled properties of the SCDWafer listview/Buttons
		/// </summary>
		/// <param name="enable"></param>
		private void EnableSCDWafer(bool enable)
		{
			//BR_26.38 - SCDWafer is required
			if (enable)
				this.btnAddWafer.Text = "Add Wafer*";
			else
				this.btnAddWafer.Text = "Add Wafer";

			this.grpWeld.Enabled = enable;
			this.lvSCDWafer.Enabled = enable;
			this.btnAddWafer.Enabled = enable;
		}

		/// <summary>
		/// Load tabOriginal with the to-split unit information
		/// </summary>
		private void PopulateSourceDetails()
		{

			this.txtOriginalUnitID.Text			= this._bumControl.SplittingUnit.EyeReadableUnitId;
			this.txtOriginalProductName.Text	= this._bumControl.SplittingUnit.FullProductCode + " - " + this._bumControl.SplittingUnit.ProductShortName;
			this.txtOriginalABORh.Text			= this._bumControl.SplittingUnit.BloodUnitMedia.AboRh.AboRHText;
			this.toolTip1.SetToolTip(this.txtOriginalABORh, this._bumControl.SplittingUnit.BloodUnitMedia.AboRh.AboRHTextExpanded);

			this.txtOriginalExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._bumControl.SplittingUnit.BloodUnitMedia.UnitExpirationDate);
			this.txtOriginalDonationType.Text	= this._bumControl.SplittingUnit.DonationType.DonationTypeText;
			this.txtOriginalUnitStatus.Text		= this._bumControl.SplittingUnit.BloodUnitStatus.UnitStatusDescriptiveText;
			
			this.txtOriginalRestrictedName.Text	= this._bumControl.SplittingUnit.DirectedPatient.DisplayName;
			this.txtOriginalRestrictedSSN.Text	= this._bumControl.SplittingUnit.DirectedPatient.DisplayPatientID;//SSN;
			this.txtOriginalRestrictedStatus.Text = BOL.TestingStatus.GetTestingStatusTextFromID(this._bumControl.SplittingUnit.BloodUnitMedia.TestingStatusId);
			
			this.picOriginalBiohazard.Visible	= this._bumControl.SplittingUnit.BloodUnitStatus.BiohazardousWarningIndicator;

			this.lvOriginalAssigned.Items.Clear();
			if (this._bumControl.SplittingUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned ||
				this._bumControl.SplittingUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned)
			{
				System.Data.DataTable dtAssignments = BOL.PatientAssignments.GetPatientSpecimenAssignmentDetails(this._bumControl.SplittingUnit.BloodUnitGuid);
				
				foreach(System.Data.DataRow dr in dtAssignments.Rows)
				{
					System.Guid patientGuid = (System.Guid)dr[TABLES.Patient.PatientGuid];
					BOL.Patient patient = new BOL.Patient(patientGuid);

					//Populate the list view with the appropriate data
					ListViewItem lvi = new ListViewItem(patient.DisplayName);
					lvi.SubItems.Add(patient.DisplayPatientID);//patient.SSN.ToString().Insert(3,"-").Insert(6,"-"));
					//
					System.Guid specimenGuid = dr.IsNull(TABLES.PatientSpecimen.PatientSpecimenGuid) ? Guid.Empty : (System.Guid)dr[TABLES.PatientSpecimen.PatientSpecimenGuid];
					if (specimenGuid != Guid.Empty)
					{
						BOL.Specimen specimen = new BOL.Specimen(specimenGuid);
						lvi.SubItems.Add(specimen.SpecimenUid);
						lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(specimen.SpecimenExpirationDate));
					}
					this.lvOriginalAssigned.Items.Add(lvi);
					
				}
				GUI.controls.VbecsFunction.SetColumnWidths(this.lvOriginalAssigned);
			}

			this.updOriginalVolume.Value = this._bumControl.SplittingUnit.OriginalVolume;

			this.cbOriginalCMVNeg.Checked = this._bumControl.SplittingUnit.CmvNegative;
			this.cbOriginalSickleCellNeg.Checked = this._bumControl.SplittingUnit.SickleCellNegative;

			this.PopulateAntigenListview();			
		}


		/// <summary>
		/// Load the created unit's information
		/// </summary>
		private void PopulateTargetDetails()
		{
			this.txtTargetUnitId.Text			= this._currentTargetUnit.NewUnit.EyeReadableUnitId;

			this.txtTargetProductName.Text		= this._currentTargetUnit.NewUnit.FullProductCode + " - " + this._currentTargetUnit.NewUnit.ProductShortName;
			this.txtTargetABORh.Text			= this._currentTargetUnit.NewUnit.BloodUnitMedia.AboRh.AboRHText;
			this.toolTip1.SetToolTip(this.txtTargetABORh, this._currentTargetUnit.NewUnit.BloodUnitMedia.AboRh.AboRHTextExpanded);

			this.dtpTargetExpirationDate.Value	= this._currentTargetUnit.UnitExpirationDate;
			this.txtTargetDonationType.Text		= this._currentTargetUnit.NewUnit.DonationType.DonationTypeText;
			this.updTargetVolume.Value			= this._currentTargetUnit.NewUnit.OriginalVolume;
			
			this.txtTargetRestrictedName.Text	= this._currentTargetUnit.NewUnit.DirectedPatient.DisplayName;
			this.txtTargetRestrictedSSN.Text	= this._currentTargetUnit.NewUnit.DirectedPatient.DisplayPatientID;
			this.txtTargetRestrictedStatus.Text = BOL.TestingStatus.GetTestingStatusTextFromID(this._currentTargetUnit.NewUnit.BloodUnitMedia.TestingStatusId);
			
			this.picTargetBiohazard.Visible		= this._currentTargetUnit.NewUnit.BloodUnitStatus.BiohazardousWarningIndicator;

			this.txtTargetUnitStatus.Text		= this._currentTargetUnit.NewUnit.BloodUnitStatus.UnitStatusDescriptiveText;
			

			this.cbTargetSickleCellNeg.Checked = this.cbOriginalSickleCellNeg.Checked;
			this.cbTargetCMVNeg.Checked = this.cbOriginalCMVNeg.Checked;

			//Replicate the original listview
			this.lvTargetAntigens.Items.Clear();
			foreach (ListViewItem lvi in this.lvOriginalAntigens.Items)
			{
				this.lvTargetAntigens.Items.Add((ListViewItem)lvi.Clone());
			}
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvTargetAntigens);
			
			//Populate all those little tabs down at the bottom
			this.PopulateContainer();
			this.PopulateEquipment();
			this.PopulateSCDWafer();
			this.PopulateSupplies();

			//Since the user can enter junk ,,.,.,. in the upd, we want to reset the ErrorProvider if they tab off the field
			//since junk isn't saved to the BOL, when the code sets the TargetVolume using the BOL, it will contain a valid
			//number, and so there will no longer be any errorprovider
			this.errError.SetVbecsError(this.updTargetVolume, string.Empty); // **** 508 Compliance ***
			this.ObjectValidityChange(this, System.EventArgs.Empty);	//BRs will still get caught
		} 


		/// <summary>
		/// Populates the Equipment listview from the _currentTargetUnit's EquipmentList property
		/// </summary>
		private void PopulateEquipment()
		{
			int nCount = 0;
			this.lvEquipment.Items.Clear();
			
			if (this._currentTargetUnit.EquipmentList.Count > 0)
			{
				nCount = this._currentTargetUnit.EquipmentList.Count;
				for(int ndx=0; ndx < nCount; ndx++)
				{
					ListViewItem lvi = new ListViewItem();
					BOL.Equipment equip = (BOL.Equipment)this._currentTargetUnit.EquipmentList[ndx];
					
					lvi.Tag = equip;
					lvi.Checked = true;
					lvi.SubItems.Add(equip.SerialNumber);
					lvi.SubItems.Add(equip.EquipmentName);
					lvi.SubItems.Add(equip.ManufacturerName);
					lvi.SubItems.Add(equip.LocalIdentifier);
					
					this.lvEquipment.Items.Add(lvi);
				}
			}
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvEquipment);
		}

		
		/// <summary>
		/// SCD Wafer is some kinda supply thing that's required? when you perform a SCD modification
		/// </summary>
		private void PopulateSCDWafer()
		{
			this.lvSCDWafer.Items.Clear();
			
			if (this._currentTargetUnit.SCDWafer.LotNumber != string.Empty)
			{
			
				ListViewItem lvi = new ListViewItem();

				lvi.Text = this._currentTargetUnit.SCDWafer.LotNumber;
				lvi.SubItems.Add(this._currentTargetUnit.SCDWafer.SupplyName);
				lvi.SubItems.Add(this._currentTargetUnit.SCDWafer.ManufacturerName);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(this._currentTargetUnit.SCDWafer.LotExpirationDate));
				
				this.lvSCDWafer.Items.Add(lvi);
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvSCDWafer);
		}


		/// <summary>
		/// Loads the container for the current selected unit. Also populates the OriginalContainer checkbox
		/// </summary>
		private void PopulateContainer()
		{

			this.lvContainer.Items.Clear();
			
			if (this._currentTargetUnit.Container.LotNumber != string.Empty)
			{
				ListViewItem lvi = new ListViewItem();

				lvi.Text = this._currentTargetUnit.Container.LotNumber;
				lvi.SubItems.Add(this._currentTargetUnit.Container.SupplyName);
				lvi.SubItems.Add(this._currentTargetUnit.Container.ManufacturerName);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(this._currentTargetUnit.Container.LotExpirationDate));
				
				this.lvContainer.Items.Add(lvi);
			}

			GUI.controls.VbecsFunction.SetColumnWidths(this.lvContainer);

			SetOriginalContainerIndicator();
		}


		/// <summary>
		/// Populates the Supply listview from the _currentTargetUnit's SupplyList property
		/// </summary>
		private void PopulateSupplies()
		{
			this.lvSupplies.Items.Clear();
			int nCount = 0;
			if (this._currentTargetUnit.SupplyList.Count > 0)
			{
				nCount = this._currentTargetUnit.SupplyList.Count;
				for(int ndx=0; ndx < nCount; ndx++)
				{
					ListViewItem lvi = new ListViewItem();
					BOL.Supply supply = (BOL.Supply)this._currentTargetUnit.SupplyList[ndx];

					lvi.Tag = supply;
					lvi.Checked = true;
					lvi.SubItems.Add(supply.LotNumber);
					lvi.SubItems.Add(supply.SupplyName);
					lvi.SubItems.Add(supply.ManufacturerName);
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateString(supply.LotExpirationDate));
					
					this.lvSupplies.Items.Add(lvi);
				}
			}
			
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvSupplies);
		}


		/// <summary>
		/// SetComponentProperties
		/// </summary>
		/// <remarks>Indy</remarks>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Split/Divide Unit";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.FrmSplitUnit());
			//
			this.btnOK.Text = "&OK";
			
			//Set up the split-number control
			this.updSplitNumber.Maximum = this._bumControl.MaximumSplitUnitsAllowed;
			this.updSplitNumber.Minimum = 2;			//You can't split something into less than two
			this.updSplitNumber.Value = this._bumControl.SplitCount;

			//set custom date and time format
			this.dtpTargetExpirationDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			this.dtpTargetExpirationDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			//Setup the Modifiation Method
			switch (this._bumControl.ModificationMethod)
			{
				case (Common.ModifyUnitMethod.Open):
					this.txtMethod.Text = "Open";
					this.EnableContainer(true);
					this.EnableSCDWafer(false);
					break;

					//BR_26.37, Closed -- cannnot assign container
				case (Common.ModifyUnitMethod.Closed):
					this.txtMethod.Text = "Closed";
					this.EnableContainer(false);
					this.EnableSCDWafer(false);
					break;
				
				case (Common.ModifyUnitMethod.SterileConnectingDevice):
					this.txtMethod.Text = "Sterile Connection Device";
					this.EnableSCDWafer(true);
					this.EnableContainer(true);
					break;
			}

			//Setup the modification DateTime
			this.txtModificationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._bumControl.ModificationDateTime);

			//Set the tooltips
			this.toolTip1.SetToolTip(this.txtOriginalProductName, this._bumControl.SplittingUnit.ProductName);
			this.toolTip1.SetToolTip(this.txtTargetProductName, this._bumControl.SplittingUnit.ProductName);

			this.toolTip1.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.toolTip1.SetToolTip(this.dtpTargetExpirationDate, Common.StrRes.Tooltips.UC026.TargetExpirationDate().ResString);
			this.toolTip1.SetToolTip(this.txtTargetUnitId, Common.StrRes.Tooltips.UC026.TargetUnitId().ResString);
			this.toolTip1.SetToolTip(this.txtTargetABORh, Common.StrRes.Tooltips.UC026.TargetAboRH().ResString);
			this.toolTip1.SetToolTip(this.updTargetVolume, Common.StrRes.Tooltips.UC026.TargetVolume().ResString);
			this.toolTip1.SetToolTip(this.txtTargetUnitStatus, Common.StrRes.Tooltips.UC026.TargetUnitStatus().ResString);
			this.toolTip1.SetToolTip(this.txtTargetDonationType, Common.StrRes.Tooltips.UC026.TargetDonationType().ResString);
			this.toolTip1.SetToolTip(this.cbTargetCMVNeg, Common.StrRes.Tooltips.UC026.TargetCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.cbTargetSickleCellNeg, Common.StrRes.Tooltips.UC026.TargetSickleCellNegative().ResString);
			this.toolTip1.SetToolTip(this.lvTargetAntigens, Common.StrRes.Tooltips.UC026.TargetAntigens().ResString);
			this.toolTip1.SetToolTip(this.lblTargetCMVNeg, Common.StrRes.Tooltips.UC026.TargetCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.lblTargetSickleCellNeg, Common.StrRes.Tooltips.UC026.TargetSickleCellNegative().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedName, Common.StrRes.Tooltips.UC026.TargetRestrictedName().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedSSN, Common.StrRes.Tooltips.UC026.TargetRestrictedSSN().ResString);
			this.toolTip1.SetToolTip(this.txtTargetRestrictedStatus, Common.StrRes.Tooltips.UC026.TargetRestrictedStatus().ResString);
			this.toolTip1.SetToolTip(this.lvSCDWafer, Common.StrRes.Tooltips.UC026.WaferList().ResString);
			this.toolTip1.SetToolTip(this.btnAddWafer, Common.StrRes.Tooltips.UC026.AddWafer().ResString);
			this.toolTip1.SetToolTip(this.lvEquipment, Common.StrRes.Tooltips.UC026.EquipmentList().ResString);
			this.toolTip1.SetToolTip(this.btnAddEquipment, Common.StrRes.Tooltips.UC026.AddEquipment().ResString);
			this.toolTip1.SetToolTip(this.lvSupplies, Common.StrRes.Tooltips.UC026.SupplyList().ResString);
			this.toolTip1.SetToolTip(this.btnAddSupplies, Common.StrRes.Tooltips.UC026.AddSupplies().ResString);
			this.toolTip1.SetToolTip(this.lvContainer, Common.StrRes.Tooltips.UC026.ContainerList().ResString);
			this.toolTip1.SetToolTip(this.btnAddContainer, Common.StrRes.Tooltips.UC026.AddContainer().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalExpirationDate, Common.StrRes.Tooltips.UC026.OriginalExpirationDate().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalUnitID, Common.StrRes.Tooltips.UC026.OriginalUnitId().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalABORh, Common.StrRes.Tooltips.UC026.OriginalAboRH().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalUnitStatus, Common.StrRes.Tooltips.UC026.OriginalUnitStatus().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalDonationType, Common.StrRes.Tooltips.UC026.OriginalDonationType().ResString);
			this.toolTip1.SetToolTip(this.cbOriginalCMVNeg, Common.StrRes.Tooltips.UC026.OriginalCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.cbOriginalSickleCellNeg, Common.StrRes.Tooltips.UC026.OriginalSickleCellNeg().ResString);
			this.toolTip1.SetToolTip(this.lvOriginalAntigens, Common.StrRes.Tooltips.UC026.OriginalAntigens().ResString);
			this.toolTip1.SetToolTip(this.lblOriginalCMVNeg, Common.StrRes.Tooltips.UC026.OriginalCMVNegative().ResString);
			this.toolTip1.SetToolTip(this.lblOriginalSickleCellNeg, Common.StrRes.Tooltips.UC026.OriginalSickleCellNeg().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedName, Common.StrRes.Tooltips.UC026.OriginalRestrictedName().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedSSN, Common.StrRes.Tooltips.UC026.OriginalRestrictedSSN().ResString);
			this.toolTip1.SetToolTip(this.txtOriginalRestrictedStatus, Common.StrRes.Tooltips.UC026.OriginalRestrictedStatus().ResString);
			this.toolTip1.SetToolTip(this.rdoIncomplete, Common.StrRes.Tooltips.UC026.IncompleteWeld().ResString);
			this.toolTip1.SetToolTip(this.rdoComplete, Common.StrRes.Tooltips.UC026.CompleteWeld().ResString);

		}

		/// <summary>
		/// Sets the original container checkbox.  
		/// BR_25.03 - Only one unit can have the share the original unit's container
		/// </summary>
		private void SetOriginalContainerIndicator()
		{
			this._manualCBSetting = false;

			//According to SME - VBECS might not have the container lot number field filled in on the database
			//All Units are in containers.
			//Find out, which unit, if any, has already opted to use the original container
			int unitUsingContainer = this._bumControl.UnitUsingOriginalContainer;

			//In a closed split, all units are assigned the original container -- we default to true for the user
			if (this._bumControl.ModificationMethod == Common.ModifyUnitMethod.Closed)
			{
				this.cbOriginalContainer.Checked = true;
				this.cbOriginalContainer.Enabled = false;
			}
			else
			{
				//Our tab index is tied into the collection order
				this.cbOriginalContainer.Checked = (this.tabTargets.SelectedIndex == unitUsingContainer);
				this.cbOriginalContainer.Enabled = true;
			}
			this._manualCBSetting = true;
		}


		/// <summary>
		/// Fires when properties are set on any of our parent/child objects
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ObjectValidityChange(object sender, System.EventArgs e)
		{                        			
			string brokenRules = this._bumControl.GetBrokenRulesMessage(this.Name);
			
			if (brokenRules == string.Empty)
			{
				//Get all the potential "error spots";
				string providerErrors = Common.Utility.SumBrokenRulesMessages(this.errError.GetError(this.updTargetVolume), this.errError.GetError(this.btnSplitUnit), this.errError.GetError(this.cbOriginalContainer));

				if (providerErrors == string.Empty)
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
					this.btnOK.EnabledButton = true;
				}
				else
				{
					this.btnOK.SetToolTip(providerErrors);
					this.btnOK.EnabledButton = false;
				}
			}
			else
			{
				this.btnOK.SetToolTip(brokenRules);
				this.btnOK.EnabledButton = false;
			}

			this.SetDirtyFlag(this, System.EventArgs.Empty);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/2/2002</CreationDate>
		///
		/// <summary>
		/// Populates the antigens tested, in the little listview
		/// </summary>
		private void PopulateAntigenListview()
		{
			this.lvOriginalAntigens.Items.Clear();

			//This will include antigens from UC1 as well as UC41
			System.Data.DataSet dsAntigens = BOL.DiscardOrQuarantineBloodUnit.GetAntigenTypingForConsistencyCheck(this._bumControl.SplittingUnit.BloodUnitGuid);

			if (dsAntigens.Tables.Count > 1)
			{
				foreach (System.Data.DataRow drItem in dsAntigens.Tables[1].Rows)
				{
					ListViewItem lvi = new ListViewItem();
				
					lvi.Text = drItem[TABLES.AntigenType.AntigenTypeName].ToString().Trim();
									
					if (System.Convert.ToBoolean(drItem[TABLES.BloodUnitAntigen.Positive]))
					{
						lvi.SubItems.Add("POS");
					}
					else
					{
						lvi.SubItems.Add("NEG");
					}
					this.lvOriginalAntigens.Items.Add(lvi);
				}
			}
			
			GUI.controls.VbecsFunction.SetColumnWidths(this.lvOriginalAntigens);
		}



		/// <summary>
		/// Sets up the tabs for the new split units.  Tabs are added/removed if needbe.
		/// </summary>
		private void CreateTargetTabs()
		{
			//Need to set _removingTabs, because when you remove a tab it fires the Tab_SelectedIndex event, which fails
			this._removingTabs = true;

			int tabCount = this.tabTargets.TabPages.Count;
			int unitNum;

			//If counts are equal, this shouldn't happen often
			if (tabCount != this._bumControl.SplitCount)
			{
				this.tabTargets.TabPages.Clear();
				tabCount = this.tabTargets.TabPages.Count;

				for (int ndx=tabCount; ndx < this._bumControl.SplitCount; ndx++)
				{
					unitNum = ndx+1;
					TabPage newTab = new TabPage();
					newTab.Text = "Target Unit " + unitNum.ToString();
					this.tabTargets.TabPages.Add(newTab);
				}
			}
			this._removingTabs = false;

		}

		#endregion

		#region Events

		
		/// <summary>
		/// This makes the original and target tiny little "extra info" tabs switch at the same time
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void ExtraInfoTabsClicked(object sender, System.EventArgs e)
		{
			if (sender == this.tabOriginalExtraInfo)
			{
				this.tabTargetExtraInfo.SelectedIndex = this.tabOriginalExtraInfo.SelectedIndex;
			}
			else if (sender == this.tabTargetExtraInfo)
			{
				this.tabOriginalExtraInfo.SelectedIndex = this.tabTargetExtraInfo.SelectedIndex;
			}

		}

//		/// <summary>
//		/// Event that will get raised to handle parent volume changes, because the SMEs want the 
//		/// UI to automatically update parent volume with any "leftover" volume from split
//		/// </summary>
//		/// <param name="sender"></param>
//		/// <param name="e"></param>
//		private void RefreshParentVolume(object sender, System.EventArgs e)
//		{
//			this._isLoading = true;
//			this.updOriginalVolume.Value = this._bumControl.OriginalUnitVolume;
//			this._isLoading = false;
//		}

		/// <summary>
		/// Refreshes the ExpirationDate - attached to weldindicatorchange event
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void RefreshExpirationDate(object sender, System.EventArgs e)
		{
			this._isLoading = true;
			this.dtpTargetExpirationDate.Value = this._currentTargetUnit.UnitExpirationDate;
			this._isLoading = false;
		}

		#endregion

		#region ControlEvents

		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddContainer_Click(object sender, System.EventArgs e)
		{
			System.Collections.ArrayList usedSupplies = new ArrayList();
			usedSupplies.Add(this._currentTargetUnit.Container);

			DlgSelectSupply dlgSelectSupply = new DlgSelectSupply(Common.SupplyType.Containers, false, usedSupplies, this._bumControl.SplittingUnit, this._bumControl);

			dlgSelectSupply.ShowDialogFromLockedParent(this, false);

            if (dlgSelectSupply.DialogResult == DialogResult.OK)
			{
				this._currentTargetUnit.Container = (BOL.Supply)dlgSelectSupply.SelectedSupplyList[0];
				
				//Turn off the original reference because we've got a new container
				this._bumControl.SetOriginalContainerIndicator(this.tabTargets.SelectedIndex, false);
				this.PopulateContainer();
			}

		}


		/// <summary>
		/// Brings up DlgSelectEquipment
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddEquipment_Click(object sender, System.EventArgs e)
		{
			DlgSelectEquipment dlgSelectEquipment = new DlgSelectEquipment(this._currentTargetUnit.EquipmentList, this._bumControl);

			dlgSelectEquipment.ShowDialogFromLockedParent(this, false);

            if (dlgSelectEquipment.DialogResult == DialogResult.OK)
			{
				this._currentTargetUnit.EquipmentList = dlgSelectEquipment.SelectedEquipmentList;
				this.PopulateEquipment();
			}
		}


		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddSupplies_Click(object sender, System.EventArgs e)
		{
			DlgSelectSupply dlgSelectSupply = new DlgSelectSupply(Common.SupplyType.AllSupplies, true, this._currentTargetUnit.SupplyList, this._bumControl.SplittingUnit, this._bumControl);

			dlgSelectSupply.ShowDialogFromLockedParent(this,false);

            if (dlgSelectSupply.DialogResult == DialogResult.OK)
			{
				this._currentTargetUnit.SupplyList = dlgSelectSupply.SelectedSupplyList;
				this.PopulateSupplies();
			}
		}


		/// <summary>
		/// Brings up DlgSelectSupply
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddWafer_Click(object sender, System.EventArgs e)
		{
			ArrayList usedSupplies = new ArrayList();
			usedSupplies.Add(this._currentTargetUnit.SCDWafer);

			DlgSelectSupply dlgSelectSupply = new DlgSelectSupply(Common.SupplyType.SCDWafer, false, usedSupplies, this._bumControl.SplittingUnit, this._bumControl);
			
			dlgSelectSupply.ShowDialogFromLockedParent(this,false);

            if (dlgSelectSupply.DialogResult == DialogResult.OK)
			{
				this._currentTargetUnit.SCDWafer = (BOL.Supply)dlgSelectSupply.SelectedSupplyList[0];
				this.PopulateSCDWafer();
			}
		}


		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}


		private void btnOK_Click(object sender, System.EventArgs e)
		{
			try
			{
				ArrayList labelMismatchExceptions = new ArrayList();
				int nCount = 0;
				string modification = Common.Utility.GetProductModificationTextFromEnum(this._bumControl.ProductModificationCode);

				//Check for existing bloodunits... JIC
				nCount = this._bumControl.SplitCount;
				for(int ndx=0; ndx < this._bumControl.SplitCount; ndx++)
				{
					System.Guid buGuid = System.Guid.Empty;

					BOL.ModifiedUnit tmpUnit = (BOL.ModifiedUnit)this._bumControl.SplitUnits[ndx];

                    if (tmpUnit.NewUnit.BarcodeType == Common.BarcodeType.Codabar)
                    {
                        //CR 2587
                        if (BOL.BloodUnit.BloodUnitExists(tmpUnit.NewUnit.EyeReadableUnitId, tmpUnit.NewUnit.BloodProductGuid,
                            tmpUnit.NewUnit.FullProductCode, ref buGuid))
                        {
                            GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR1_40(tmpUnit.NewUnit.EyeReadableUnitId, tmpUnit.NewUnit.ProductType.ProductTypeText));
                            return;
                        }
                    }
                    else
                    {
                        //If this continues, the unit was found, throwing in row check..just in case BOL/DAL code changes
                        System.Data.DataTable dtCheck = BOL.BloodUnit.GetBloodUnitsByIdAndProduct(tmpUnit.NewUnit.EyeReadableUnitId, tmpUnit.NewUnit.ProductCode, Common.LogonUser.LogonUserDivisionCode, tmpUnit.NewUnit.UnitDivisionId, tmpUnit.NewUnit.DonationType.DonationTypeCode.ToString(), Common.AdditionalBloodUnitSearchCriteria.None);
                        if (dtCheck.Rows.Count > 0)     //CR3294 - removed try/catch(absorb) that fired when Rows.Count = 0
                        {
                            GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR1_40(tmpUnit.NewUnit.EyeReadableUnitId, tmpUnit.NewUnit.ProductType.ProductTypeText));
                            return;
                        }
                    }
				}//endfor

		
				//BR_26.25
				if (this._bumControl.SplittingUnit.AssignedToPatients.Count > 0)
				{
					DlgModifyAssignments dlgPatientAssignments = new DlgModifyAssignments(this._bumControl.SplittingUnit);

					dlgPatientAssignments.ShowDialogFromLockedParent(this,false);

                    if (dlgPatientAssignments.DialogResult == DialogResult.OK)
					{
						this._bumControl.InheritedPatientAssignment = dlgPatientAssignments.SelectedPatientAssignment;
					}
				}

				//BR_26.24 - Verify before Continueing...
				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ReadyToVerifyLabeling(modification), MessageBoxDefaultButton.Button2) == DialogResult.Yes)
				{
					FormWindowState currentState = this.WindowState;
					this.WindowState = FormWindowState.Minimized;
					nCount = this._bumControl.SplitCount;
					for(int ndx=0; ndx < nCount; ndx++)
					{
						DlgVerifyModifiedUnit dlgVerifyLabel = new DlgVerifyModifiedUnit((BOL.ModifiedUnit)this._bumControl.SplitUnits[ndx], this._bumControl, ndx+1);

						dlgVerifyLabel.ShowDialogFromLockedParent(this,false);

                        if (dlgVerifyLabel.DialogResult == DialogResult.OK)
						{
							((BOL.ModifiedUnit)this._bumControl.SplitUnits[ndx]).NewLabelVerificationDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
						}

						((BOL.ModifiedUnit)this._bumControl.SplitUnits[ndx]).LabelVerificationFailed = (dlgVerifyLabel.LabelMismatchExceptions.Count > 0);

						//Add any exceptions to the exception arraylist
						for (int ndx2=0; ndx2 < dlgVerifyLabel.LabelMismatchExceptions.Count; ndx2++)
						{
							this._bumControl.LabelExceptions.Add(dlgVerifyLabel.LabelMismatchExceptions[ndx2]);
						}

					}
					this.WindowState = currentState;
				}

				if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave(modification)) == DialogResult.Yes)
				{
					if (this._bumControl.Save(Common.UpdateFunction.UC025FrmSplitUnits))
					{
						this.IsDirty = false;
						this.Close();
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved(modification));
						return;
					}
					//CR 1441 - Changed from harcoded WorkloadProcessId to WorkloadCode property to localize changes in future if SplitChild comes on board
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int)this._bumControl.WorkloadCode);
					if(dt!= null)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
				}
			}
			catch(Common.RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
		}

		/// <summary>
		/// Handles the manual entry of UnitExpirationDate
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void dtpTargetExpirationDate_Leave(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				if (this.dtpTargetExpirationDate.Value == this._currentTargetUnit.UnitExpirationDate)
					return;

				//BR_26.21 - check the target's expiraton date
				if (this.dtpTargetExpirationDate.Value > this._currentTargetUnit.RecommendedExpirationDateTime(this._bumControl))
				{
					if (ThisUser.CurrentDivisionRole.Role.UserRoleId >= Common.UserRoleType.EnhancedTechnologist)
					{
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
						{
							DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(this._currentTargetUnit.NewUnit, Common.StrRes.ValidMsg.UC026.BR21TargetDateRange(this._currentTargetUnit.NewUnit.EyeReadableUnitId, this._currentTargetUnit.NewUnit.ProductType.ProductTypeText).ResString);

							dlgExpire.ShowDialogFromLockedParent(this,false);
                            if (dlgExpire.DialogResult == DialogResult.Abort) return;

                            if (dlgExpire.DialogResult == DialogResult.OK)
							{
								this._currentTargetUnit.UnitExpirationDate = this.dtpTargetExpirationDate.Value;
								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Target_product_outdate_extended, dlgExpire.Comment, Common.LogonUser.LogonUserName);
								exRep.GenerateExceptionUnitModification(this._currentTargetUnit.NewUnit, this._bumControl, this._currentTargetUnit.RecommendedExpirationDateTime(this._bumControl),null);
								this._bumControl.Exceptions.Add(exRep);
							}
							else
							{
								//Since we're not disabling the OK button (nor changing the Objects value
								//Let the user see what's actually being saved
								this.dtpTargetExpirationDate.Value = this._currentTargetUnit.RecommendedExpirationDateTime(this._bumControl);
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						}
					}
					else
					{
						//BR_26.28 - Security Level 1 check
						GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC026.BR28ExpirationDateOutOfRange(this._currentTargetUnit.NewUnit.EyeReadableUnitId, this._currentTargetUnit.NewUnit.ProductType.ProductTypeText));
						this.dtpTargetExpirationDate.Value = this._currentTargetUnit.UnitExpirationDate;
					}
				}
				else
				{
					this._currentTargetUnit.UnitExpirationDate = this.dtpTargetExpirationDate.Value;
				}
			}
		}

		/// <summary>
		/// Fires when any of the child units changes it's volume
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void TargetVolumeEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					//This is probably a deviation from the norm, but this use case is also is unlike any other
					//The updTargetVolume has it's Max and Min set to huge numbers, so if the user enters
					//and invalid value and then clicks on another child tab the invalid number will still remain.
					//Because our VBECS control throws a FormatException when the user enters a value outside of the range, we
					//would never get to incorrectly set the BOL object (and thus set the BrokenRule).
					
					//The only other "hiccup" is if the user enters ..,,.,.,.,  or junk like that.. Then we have to check on the ErrorProvider
					//Hence the ObjectValidity call below
					this._currentTargetUnit.NewUnit.OriginalVolume = this.updTargetVolume.Value;
					this.errError.SetVbecsError(this.updTargetVolume, string.Empty); // **** 508 Compliance ***
				}
				catch(Exception err)
				{
					//In order for broken rules to work properly, we'd need the upd control to have no bounds
					this.errError.SetVbecsError(this.updTargetVolume, err.Message); // **** 508 Compliance ***
				}
				finally
				{
					this.ObjectValidityChange(this, System.EventArgs.Empty);
				}
			}
		}	

		private void updTargetVolume_Leave(object sender, System.EventArgs e)
		{
			try
			{
				this._isLoading = true;
				//this.updTargetVolume.Value = this.updTargetVolume.Value;
				this._currentTargetUnit.NewUnit.OriginalVolume = this.updTargetVolume.Value;
				this.errError.SetVbecsError(this.updTargetVolume, string.Empty); // **** 508 Compliance ***
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.updTargetVolume, err.Message); // **** 508 Compliance ***
			}
			this._isLoading = false;
		}
		/// <summary>
		/// Sets the Checkbox and disables the grid, or visa versa
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbOriginalContainer_CheckedChanged(object sender, System.EventArgs e)
		{
			try
			{
				if (this._manualCBSetting)
				{
					this._bumControl.SetOriginalContainerIndicator(this.tabTargets.SelectedIndex, cbOriginalContainer.Checked);
					this._currentTargetUnit.Container = new BOL.Supply(System.Guid.Empty);
					this.PopulateContainer();
				
					this.errError.SetVbecsError(this.cbOriginalContainer, String.Empty); // **** 508 Compliance ***
				}
			}
			catch(BOL.BusinessObjectException exp)
			{
				this.errError.SetVbecsError(this.cbOriginalContainer, exp.Message); // **** 508 Compliance ***
			}
		}


		private void lvSupplies_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 4)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else 
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvSupplies.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		
		private void lvEquipment_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvEquipment.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
		}

		/// <summary>
		/// Supply Items 
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvSupplies_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			BOL.Supply trgSupply = (BOL.Supply)this.lvSupplies.Items[e.Index].Tag;
			int foundNdx = -1;

			for (int ndx=0; ndx < this._currentTargetUnit.SupplyList.Count; ndx++)
			{
				BOL.Supply srcSupply = (BOL.Supply)this._currentTargetUnit.SupplyList[ndx];

				if (srcSupply.SupplyGuid == trgSupply.SupplyGuid)
				{
					foundNdx = ndx;
					break;
				}
			}

			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				if (foundNdx == -1)	//If they're checking and it doesn't already exist...add it
					this._currentTargetUnit.SupplyList.Add(trgSupply);
			}
			else
			{
				if (foundNdx > -1)	//They're unchecking and it's inside the list.... remove it
					this._currentTargetUnit.SupplyList.RemoveAt(foundNdx);
			}
		}

		private void lvEquipment_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			BOL.Equipment trgEquip = (BOL.Equipment)this.lvEquipment.Items[e.Index].Tag;
			int foundNdx = -1;

			for (int ndx=0; ndx < this._currentTargetUnit.EquipmentList.Count; ndx++)
			{
				BOL.Equipment srcEquip = (BOL.Equipment)this._currentTargetUnit.EquipmentList[ndx];

				if (srcEquip.EquipmentGuid == trgEquip.EquipmentGuid)
				{
					foundNdx = ndx;
					break;
				}
			}

			if (e.NewValue == System.Windows.Forms.CheckState.Checked)
			{
				if (foundNdx == -1)	//If they're checking and it doesn't already exist...add it
					this._currentTargetUnit.EquipmentList.Add(trgEquip);
			}
			else
			{
				if (foundNdx > -1)	//They're unchecking and it's inside the list.... remove it
					this._currentTargetUnit.EquipmentList.RemoveAt(foundNdx);
			}

		}

		private void btnSplitUnit_Click(object sender, System.EventArgs e)
		{
			using ( new WaitCursor() ) 
			{
				this.btnSplitUnit.Enabled = false;
				try
				{
					this._bumControl.SplitAgain((int)this.updSplitNumber.Value);
					this.CreateTargetTabs();

					//Set the tab to the first one, so the change event is fired
					if (this.tabTargets.SelectedIndex == 0)
						this.tabTargets_SelectedIndexChanged(this, System.EventArgs.Empty);
					else
						this.tabTargets.SelectedIndex = 0;
				}
				catch (BOL.BusinessObjectException exp)
				{	
					if(exp.Message ==Common.StrRes.InfoMsg.UC025.RanOutOfAlphabet().ResString)
					{
						this.btnSplitUnit.Enabled = true;
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC025.RanOutOfAlphabet());
					}
				}
				
			}
		}




		/// <summary>
		/// Fires when the user moves from tab to tab.  Also fires when tabs are removed via CreateTargetTabs
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void tabTargets_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._removingTabs)
			{
				this._currentTargetUnit = (BOL.ModifiedUnit)this._bumControl.SplitUnits[this.tabTargets.SelectedIndex];
				this.PopulateTargetDetails();
			}
		}

		private void rdoComplete_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoComplete.Checked)
				this._bumControl.NewContainerWeldIndicator = true;
		}

		private void rdoIncomplete_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this.rdoIncomplete.Checked)
			{
				this._bumControl.NewContainerWeldIndicator = false;
			}
		}
		
		/// <summary>
		/// This is to update the NumericUpDown, because if you type a value that is less than the minimum
		/// it won't update the control to the NumericUpDown.Minimum until you click one of the up/down arrows
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void SplitNumberEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this.updSplitNumber.Value = this.updSplitNumber.Value;

					if (this.updSplitNumber.Value != this.tabTargets.TabCount)
					{
						this.btnSplitUnit.Enabled = true;
						this.btnSplitUnit.Text = "Split*";
					}
					else
					{
						this.btnSplitUnit.Enabled = false;
						this.btnSplitUnit.Text = "Split";
					}
					this.errError.SetVbecsError(updSplitNumber, string.Empty); // **** 508 Compliance ***
				}
				catch
				{
					this.btnSplitUnit.Enabled = false;
				}
			}
		}

		private void SplitNumberLeaveEvent(object sender, System.EventArgs e)
		{
			if (!this._isLoading)
			{
				try
				{
					this.updSplitNumber.Value = this.updSplitNumber.Value;

					if (this.updSplitNumber.Value != this.tabTargets.TabCount)
					{
						this.btnSplitUnit.Enabled = true;
						this.btnSplitUnit.Text = "Split*";
					}
					else
					{
						this.btnSplitUnit.Enabled = false;
						this.btnSplitUnit.Text = "Split";
					}
					this.errError.SetVbecsError(updSplitNumber, string.Empty); // **** 508 Compliance ***
				}
				catch(FormatException err)
				{
					this.errError.SetVbecsError(updSplitNumber, err.Message); // **** 508 Compliance ***
					this.btnSplitUnit.Enabled = false;
				}
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmSplitUnit_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnOK.EnabledButton )
			{
				this.SpeakMessage( this.btnOK.GetToolTip() );
			}
		}

		#endregion
	}
}